package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm;

import org.apache.log4j.Logger;

/**
 * Response-object that is being transmitted from witness to the client as answer
 * to some context-creation-request
 */
public class ContextCreationResponse implements IFContextCreationResponse{

   private static final Logger logger = Logger.getLogger(ContextCreationResponse.class);

   private boolean success = false;
   private String nonce = null;

   /**
    * @see IFContextCreationResponse#isSuccess()
    */
   public boolean isSuccess() {
      return success;
   }

   /**
    * Sets wheather this creation has been performed successfull by the witness or not.
    * @param success
    */
   public void setSuccess(boolean success) {
      this.success = success;
   }

   /**
    * @see IFContextCreationResponse#getNonce()
    */
   public String getNonce() {
      return nonce;
   }

   /**
    * Sets the NONCE-value to this response (the one from the according request)
    * @param nonce the nonce value
    */
   public void setNonce(String nonce) {
      this.nonce = nonce;
   }

}
