package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.comm;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.AccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.account.IFAccountIdentification;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.BaseContext;

/**
 * Request-object that is being transmitted form client to witness to create
 * new context.
 */
public class ContextCreationRequest extends BaseContext implements IFContextCreationRequest{

   private static final Logger logger = Logger.getLogger(ContextCreationRequest.class);

   private String nonce = null;
   private long timeoutMSRequest = 0;
   private long timeoutMSResponse = 0;
   private long lifeTimeMS = 0;
   private long currentTs = 0;
   private IFAccountIdentification accountIdentification = null;

   /**
    * Creates a new default-instance<br/>
    * NONCE: currenTimeMillis()<br/>
    * AccountIdentification: default-instance<br/>
    * Timeout on Request: 10sek<br/>
    * Timeout on Response: 10sek<br/>
    * Lifetime of th context: 20min
    */
   public ContextCreationRequest() {
      setNonce("" + System.currentTimeMillis());
      setAccountIdentification(new AccountIdentification());
      setTimeoutMSRequest(10*1000);
      setTimeoutMSResponse(10*1000);
      setLifeTimeMS(20*60*1000); //20min
      setCurrentTs(System.currentTimeMillis());
   }

   /**
    * @see IFContextCreationRequest#getNonce()
    */
   public String getNonce() {
      return nonce;
   }

   /**
    * Gets the NONCE-value.
    * @param nonce
    */
   public void setNonce(String nonce) {
      this.nonce = nonce;
   }

   /**
    * @see IFContextCreationRequest#getTimeoutMSRequest()
    */
   public long getTimeoutMSRequest() {
      return timeoutMSRequest;
   }

   /**
    * Sets the timeout for digest agreement on request-phase
    * @param timeoutMSRequest timeout in millis
    */
   public void setTimeoutMSRequest(long timeoutMSRequest) {
      this.timeoutMSRequest = timeoutMSRequest;
   }

   /**
    * @see IFContextCreationRequest#getTimeoutMSResponse()
    */
   public long getTimeoutMSResponse() {
      return timeoutMSResponse;
   }

   /**
    * Sets the timeout for digest agreement on response-phase
    * @param timeoutMSResponse timeout in millis
    */
   public void setTimeoutMSResponse(long timeoutMSResponse) {
      this.timeoutMSResponse = timeoutMSResponse;
   }

   /**
    * @see IFContextCreationRequest#getLifeTimeMS()
    */
   public long getLifeTimeMS() {
      return lifeTimeMS;
   }

   /**
    * Sets the liftime of the context to be created
    * @param lifeTimeMS lifetime in millis
    */
   public void setLifeTimeMS(long lifeTimeMS) {
      this.lifeTimeMS = lifeTimeMS;
   }


   /**
    * @see IFContextCreationRequest#getAccountIdentification()
    */
   public IFAccountIdentification getAccountIdentification() {
      return accountIdentification;
   }

   /**
    * Sets the accountIdentification to identify the entities account at the witness.
    * @param accountIdentification The identification.
    */
   public void setAccountIdentification(IFAccountIdentification accountIdentification) {
      this.accountIdentification = accountIdentification;
   }

   /**
    * @see IFContextCreationRequest#getCurrentTs()
    */
   public long getCurrentTs() {
      return currentTs;
   }

   /**
    * Sets the current timestamp
    * @param currentTs current timestamp in millis
    */
   public void setCurrentTs(long currentTs) {
      this.currentTs = currentTs;
   }

}
