package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.dependency.IFSOAPDependency;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

/**
 * The interface for the data that represents a step-context (the context that is
 * being used for every single communication within some context -&gt; step 1 to 6 in written
 * part of this diploma thesis)
 */
public interface IFStepContext {

   /**
    * Return the Nonce-value of this step-context. This value is being used
    * to prevent replay-attacks and to refer to messages over single request/response-processes.
    * @return The nonce-value.
    */
   public String getNonce();

   /**
    * Gets the dependencies that should be included in the digest-agreement-request that
    * is being sent to the witness.
    * @return The dependencies
    */
   public IFSOAPDependency getDependency();

   /**
    * Defines wheather or not there shall be a digest agreement using witness in this step.
    * @return true if agreement should be performed, false else
    */
   public boolean isPerformDigestAgreementInStep();


   /**
    * Checks wheather the result of the digest-agreement-process and its reference (in prototype
    * the digest) should be kept for later referenciation. "Later Referenciation" means a later communication
    * with the same or some related service.
    * @return true if result should be kept, false else
    */
   public boolean isKeepForLaterReferencing();

   /**
    * Generates the org.w3c.dom.Element out of the set data within this instance that than in
    * turn can be placed in the Header of some SOAP-message
    * @param doc Document into which the Element shall be placed afterwards.
    * @param countingContext The surrounding counting-context-element that is be used for NS-lookups f.e.
    * @return The generated Element
    */
   public Element makeContextElement(Document doc, Element countingContext);

   /**
    * Get the unigue contextID that is being placed within the step-context to supported differenciated
    * signature-creation (coordination-context and step-context stand-alone) without loosing the connextion
    * between them.
    * @return The unique identification of the surrounding context
    */
   public String getCoordinationCtxIdentification();

}
