package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

/**
 * The interface for the state-info that is being returned by the contextManager in case
 * he is asked for the state of some particular digest-agreement-process.
 */
public interface IFDigestAgreementStateInfo {

   /**
    * Nothing known about the state.
    */
   public static final int STATE_UNKNOWN = 0;

   /**
    * Digest-agreement-process has been completed successfully.
    */
   public static final int STATE_SUCCESS = 1;

   /**
    * Digest-agreement-process has failed because of some reason.
    */
   public static final int STATE_FAILED = 2;

   /**
    * The digest-agreement-request is still running (witness sent no decision yet)
    */
   public static final int STATE_WAITING = 3;

   /**
    * Get the nonce that must be used to reference (nonce) former
    * agreements at the witness.
    * @return
    */
   public String getReferenciationNonce();

   /**
    * Gets the state of this info-object.<br/>
    * possible result: STATE_UNKNOWN, STATE_SUCCESS, STATE_FAILED or STATE_WAITING
    * @return
    */
   public int getState();

   /**
    * Checks wheather the state is STATE_UNKNOWN.
    * @return true if unknown, false else
    */
   public boolean isUnknown();

   /**
    * Checks wheather the state is STATE_SUCCESS.
    * @return true if unknown, false else
    */
   public boolean isSuccess();

   /**
    * Checks wheather the state is STATE_FAILED.
    * @return true if unknown, false else
    */
   public boolean isFailed();

   /**
    * Checks wheather the state is STATE_WAITING.
    * @return true if unknown, false else
    */
   public boolean isWaiting();

}
