package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import org.w3c.dom.Element;

/**
 * The interface for the representation of a counting-context (the one that surrounds
 * coordination-context and step-context).
 */
public interface IFCountingContext {

   /**
    * Gets the coordination-context belonging to this counting-context.
    * @return The coordination-context.
    */
   public IFCoordinationContext getCoordinationContext();

   /**
    * Gets the step-context belonging to this counting-context.
    * @return The step-context.
    */
   public IFStepContext getStepContext();

   /**
    * Gets this counting-context as org.w3c.dom.Element that may than be placed into
    * some SOAP-Header in turn.
    * @return The counting-context in XML-Element-representation.
    */
   public Element getContextElement();

   /**
    * Stets the new Step-context for the sommunication that will be performed next.
    * @param context The new step-context
    */
   public void setStepContext(IFStepContext context);

   /**
    * Gets the unique context-identification (taken form the coordination-context within
    * this counting-context-instance)
    * @return The unique identifier
    */
   public String getIdentification();

}
