package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import org.w3c.dom.Element;

/**
 * The base-interfaces that represents some coordination-context. A Coordination-context
 * is that part in the SOAP-Header that represents the global context (the one that the owning
 * client may share with as much services as he wants).
 */
public interface IFCoordinationContext extends IFBaseContext{

   /**
    * Get the unique identification of this coordination-context.
    * @return
    */
   public String getIdentification();

   /**
    * Get the XML-Element-Representation of this object. This Element is
    * intended to be placed into the header of a SOAP-Message.
    * @return The created Element
    */
   public Element getContextElement();

   /**
    * Gets the Type of this Coordination-Context. In an environment with several
    * simultaneously running WS-Coordination-Context this String identifies the context
    * that should be used by out prototype.
    * @return
    */
   public String getCoordinationType();

   /**
    * Gets the Expiration-Time of this context-object (millis since 1980). Every service should
    * check this time before performing any operation that requires a fee. The service must be sure
    * that the context lives as long as that it is possible to collect the fee after it finishes its service.
    * @return The time the context expires (millis since 1980)
    */
   public String getExpires();

   /**
    * Gets the expires-timestamp as long.
    * @return The expires-time as long (millis since 1980).
    * @see #getExpires()
    */
   public long getExpiresLong();

   /**
    * Gets the adress of the registration service (in prototype the witness).
    * @return The registration-service (URL-format)
    */
   public String getRegistrationServiceAddress();

   /**
    * Gets the time this context was created in millis since 1980.
    * @return The timestamp this context was created.
    */
   public String getCreationTime();

   /**
    * Gets the duration the witness should wait for the second digest-agrment-request
    * after the first arrives (millis) in request-phase. After that duration some
    * failure-handling is initiated.
    * @return The maximum duration to wait in millis.
    */
   public String getTimeoutDigestAgreementOnRequestPhaseMS();

   /**
    * Gets the duration as long.
    * @return The maximum duration to wait.
    * @see #getTimeoutDigestAgreementOnRequestPhaseMS()
    *
    */
   public long getTimeoutDigestAgreementOnRequestPhaseMSLong();

   /**
    * Gets the duration the witness should wait for the second digest-agrment-request
    * after the first arrives (millis) in response-phase. After that duration some
    * failure-handling is initiated.
    * @return The maximum duration to wait in millis.
    */
   public String getTimeoutDigestAgreementOnResponsePhaseMS();

   /**
    * Gets the duration as long.
    * @return The maximum duration to wait.
    * @see #getTimeoutDigestAgreementOnResponsePhaseMS() 
    */
   public long getTimeoutDigestAgreementOnResponsePhaseMSLong();
}
