package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.IFCommunicationInitiatedListener;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.IFCommunicationClosedListener;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.IFDigestAgreementInitiatedListener;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.listener.IFDigestAgreementClosedListener;

/**
 * The base-interface for the client- and service-context-manager.
 */
public interface IFContextManager {

   /**
    * Registers a newly started digest-agreement-process which is being assigned to the
    * belonging communication-process in turn.
    * @param contextID The ID of the surrounding context.
    * @param request The request that has been send to the witness-service.
    * @param communicationNonce The identifier of the communication-process surrounding
    * the digest-agreement-process
    * @return
    */
   public boolean registerDigestAgreementStarted(String contextID, IFDigestAgreementRequest request, String communicationNonce);

   /**
    * Registers a successfull performed digest-agreement-process which is assigned to the
    * belonging communication-process and digest-agreement-process in turn.
    * @param contextID
    * @param response
    * @param bodyEvidence
    * @return
    */
   public boolean registerSuccessfullDigestAgreement(String contextID, IFDigestAgreementResponse response, IFBodyEvidence bodyEvidence);

   /**
    * Gets the state-info to obtain the nonce-value that must be used in the response-phase
    * digestAgreementRequest and to get additional Information about the belonging
    * (maybe still running) request-phase digestAgreementProcess.
    * @param contextID
    * @param communicationNonce
    * @return
    */
   public IFDigestAgreementStateInfo getStateInfo4ResponsePhaseDigestAgreementRequest(String contextID, String communicationNonce);

   /**
    * Indicates that a communication (consisting of request/response and 2 digestAgreement-phases
    * has started)
    * @param context
    */
   public boolean registerCommunicationStarted(IFCountingContext context);

   /**
    * Cecks wheather the communication-process with the identifier <i>nonce</i> running
    * within the context identified by <i>contextID</i> has open/running digest-agreement-processes
    * in its request-phase.
    * @param contextID The ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true is some running process exist, false else
    */
   public boolean isRunningDigestAgreementRequestPhase(String contextID, String nonce);

   /**
    * Checks wheather the request-phase digest-agreement-process has been completed successfully.
    * @param contextID The unique ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true if the process has been completed succesfully
    */
   public boolean isSuccessfullCompletedDigestAgreementRequestPhase(String contextID, String nonce);

   /**
    * Checks wheather the request-phase digest-agreement-process has failed.
    * @param contextID The unique ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true if the process has failed
    */
   public boolean isFailedDigestAgreementRequestPhase(String contextID, String nonce);

   /**
    * Cecks wheather the communication-process with the identifier <i>nonce</i> running
    * within the context identified by <i>contextID</i> has open/running digest-agreement-processes
    * in its response-phase.
    * @param contextID The ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true is some running process exist, false else
    */
   public boolean isRunningDigestAgreementResponsePhase(String contextID, String nonce);

   /**
    * Checks wheather the responset-phase digest-agreement-process has been completed successfully.
    * @param contextID The unique ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true if the process has been completed succesfully
    */
   public boolean isSuccessfullCompletedDigestAgreementResponsePhase(String contextID, String nonce);

   /**
    * Checks wheather the response-phase digest-agreement-process has failed.
    * @param contextID The unique ID of the surrounding context.
    * @param nonce The identification of the communication-process
    * @return true if the process has failed
    */
   public boolean isFailedDigestAgreementResponsePhase(String contextID, String nonce);

   /**
    * Gets the internal context-representation of the context that is being referenced by the
    * given coordination-context.
    * @param coordinationContext The coordination-context to search for.
    * @return The IFContextInfo-object if exists, NULL else
    */
   public IFContextInfo getContext(IFCoordinationContext coordinationContext);

   /**
    * Gets the internal context-representation of the context that is being referenced by the
    * given unique context-identifier.
    * @param ident The context identifier to search for.
    * @return The IFContextInfo-object if exists, NULL else
    */
   public IFContextInfo getContext(String ident);

   /**
    * Adds a new listener for events on communication-process-initiation.
    * @param listener the listener to be added
    */
   public void addCommunicationInitiatedListener(IFCommunicationInitiatedListener listener);

   /**
    * Removes a listener for events on communication-process-initiation.
    * @param listener the listener to be removed
    */
   public void removeCommunicationInitiatedListener(IFCommunicationInitiatedListener listener);

   /**
    * Adds a new listener for events on communication-process-closing.
    * @param listener the listener to be added
    */
   public void addCommunicationClosedListener(IFCommunicationClosedListener listener);

   /**
    * Removes a listener for events on communication-process-closing.
    * @param listener the listener to be removed
    */
   public void removeCommunicationClosedListener(IFCommunicationClosedListener listener);

   /**
    * Adds a new listener for events on digestAgreement-process-initiation.
    * @param listener the listener to be added
    */
   public void addDigestAgreementInitiatedListener(IFDigestAgreementInitiatedListener listener);

   /**
    * Removes a listener for events on digestAgrement-process-initiation.
    * @param listener the listener to be removed
    */
   public void removeDigestAgreementInitiatedListener(IFDigestAgreementInitiatedListener listener);

   /**
    * Adds a new listener for events on digestAgreement-process-closing.
    * @param listener the listener to be added
    */
   public void addDigestAgreementClosedListener(IFDigestAgreementClosedListener listener);

   /**
    * Removes a listener for events on digestAgrement-process-closing.
    * @param listener the listener to be removed
    */
   public void removeDigestAgreementClosedListener(IFDigestAgreementClosedListener listener);
}
