package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

/**
 * Interface that represents one Core-Context (allowed signature-algorithms and digest-algorithms).<br/>
 * @see BaseContext 
 */
public interface IFBaseContext {

   /**
    * Gets the allowed signature-algorithms (in first state supported by client an witness;
    * if supported by service must be checked before... maybe out of the services WS-Policy? -&gt; see in outlook of written part).<br/>
    * One of them must be used by client, witness and service.
    * @return the list of allowed sig-algorithms
    */
   public String[] getAllowedSignatureAlgorithms();

   /**
    * Gets the digest-algorithm (must be used by witness and service or the protocol will definitly fail!)
    * @return the digest-algorithm that must be used
    */
   public String getDigestAlgorithm();

}
