package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import org.apache.log4j.Logger;

/**
 * State-information that is being returned by the context-manager if
 * someone asks for the current state of some digest-agreement-request (within some context
 * and communication)
 */
public class DigestAgreementStateInfo implements IFDigestAgreementStateInfo{

   private static final Logger logger = Logger.getLogger(DigestAgreementStateInfo.class);

   private int state = STATE_UNKNOWN;

   private String referenciationNonce = null;

   /**
    * @see IFDigestAgreementStateInfo#getReferenciationNonce()
    */
   public String getReferenciationNonce() {
      return referenciationNonce;
   }

   /**
    * Sets the reference (in prototype the digest) for the digest-agreement-process.
    * @param referenciationNonce the new reference
    */
   public void setReferenciationNonce(String referenciationNonce) {
      this.referenciationNonce = referenciationNonce;
   }

   /**
    * @see IFDigestAgreementStateInfo#getState()
    */
   public int getState() {
      return state;
   }

   /**
    * Sets the state of the digest-agreement-response (success, failed or waiting)
    * @param state
    */
   public void setState(int state) {
      this.state = state;
   }

   /**
    * @see IFDigestAgreementStateInfo#isUnknown()
    */
   public boolean isUnknown() {
      return state == STATE_UNKNOWN;
   }

   /**
    * @see IFDigestAgreementStateInfo#isSuccess()
    */
   public boolean isSuccess() {
      return state == STATE_SUCCESS;
   }

   /**
    * @see IFDigestAgreementStateInfo#isFailed()
    */
   public boolean isFailed() {
      return state == STATE_FAILED;
   }

   /**
    * @see IFDigestAgreementStateInfo#isWaiting() 
    */
   public boolean isWaiting() {
      return state == STATE_WAITING;
   }

}
