package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.NS;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;

/**
 * This class represents a counting context (consisting of coordination context and step context)
 * that is red from the SOAP-header (maybe created by the witness too and than written to the header)
 */
public class CountingContext implements IFCountingContext{

   private static final Logger logger = Logger.getLogger(CountingContext.class);

   private Element contextElement = null;
   private IFCoordinationContext coordinationContext = null;
   private IFStepContext stepContext = null;

   /**
    * @see IFCountingContext#getContextElement()
    */
   public Element getContextElement() {
      return contextElement;
   }

   /**
    * Sets the context-Element that is than splitted into coordination-context-portion and step-contexte-portion
    * @param contextElement the context-element
    */
   public void setContextElement(Element contextElement) {
      this.contextElement = contextElement;
      if(contextElement != null){
         Element coordinationContext = (Element)contextElement.getElementsByTagNameNS(NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE, Constants.ELEMENT_NAME_COORDINATION_CONTEXT).item(0);
         if(coordinationContext != null){
            CoordinationContext ctx = new CoordinationContext();
            ctx.setContextElement((Element) coordinationContext.cloneNode(true));
            setCoordinationContext(ctx);
         }
         Element stepContext = (Element) contextElement.getElementsByTagNameNS(NS.ACCESS_CONTROL_PROTOTYP_NAMESPACE, Constants.ELEMENT_NAME_STEP_CONTEXT).item(0);
         if(stepContext != null){
            StepContext ctx = new StepContext();
            ctx.setContextElement((Element) stepContext.cloneNode(true));
            setStepContext(ctx);
            contextElement.removeChild(stepContext);
         }
      }
   }

   /**
    * @see IFCountingContext#getCoordinationContext()
    */
   public IFCoordinationContext getCoordinationContext() {
      return coordinationContext;
   }

   /**
    * Sets the coordination-context.
    * @param coordinationContext
    */
   public void setCoordinationContext(IFCoordinationContext coordinationContext) {
      this.coordinationContext = coordinationContext;
   }

   /**
    * @see IFCountingContext#getStepContext()
    */
   public IFStepContext getStepContext() {
      return stepContext;
   }

   /**
    * Sets the step-context
    * @param stepContext
    */
   public void setStepContext(IFStepContext stepContext) {
      this.stepContext = stepContext;
   }

   /**
    * @see IFCountingContext#getIdentification() 
    */
   public String getIdentification() {
      String result = null;
      if(getCoordinationContext() != null){
         result = getCoordinationContext().getIdentification();
      }
      return result;
   }


}
