package de.tu_dresden.diplom.richter_mirko_mat2628335.common.context;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.Constants;

/**
 * The base-class of all classes that contains declarations of allowed signature-algorithms
 * and allowed digest-algorithms.
 */
public class BaseContext implements IFBaseContext{

   private static final Logger logger = Logger.getLogger(BaseContext.class);

   private String[] allowedSignatureAlgorithms = null;
   private String digestAlgorithm = null;

   /**
    * Creates a context with default-configuration<br/>
    * alowedDigestAlgorithm: Constants.NS_DIGEST_ALGORITHM_SHA1<br/>
    * allowedSignatureAlgorithms: Constants.NS_SIGNATURE_ALGORITHM_RSA_SHA1
    */
   public BaseContext() {
      setDigestAlgorithm(Constants.NS_DIGEST_ALGORITHM_SHA1);
      setAllowedSignatureAlgorithms(new String[]{Constants.NS_SIGNATURE_ALGORITHM_RSA_SHA1});
   }

   /**
    * @see IFBaseContext#getAllowedSignatureAlgorithms()
    */
   public String[] getAllowedSignatureAlgorithms() {
      return allowedSignatureAlgorithms;
   }

   /**
    * Sets the allowed signature-algorithms (in first state supported by client an witness;
    * if supported by service must be checked before... maybe out of the services WS-Policy? -&gt; see in outlook of written part).<br/>
    * One of them must be used by client, witness and service.
    * @param allowedSignatureAlgorithms signature-algorithms that may be used
    */
   public void setAllowedSignatureAlgorithms(String[] allowedSignatureAlgorithms) {
      this.allowedSignatureAlgorithms = allowedSignatureAlgorithms;
   }

   /**
    * Adds a signature-algorithm to the managed list of this instance.
    * @param alg
    */
   public void addAllowedSignatureAlgorithm(String alg){
      String[] current = getAllowedSignatureAlgorithms();
      if(current != null){
         String[] temp = new String[current.length+1];
         System.arraycopy(current, 0, temp, 0, current.length);
         temp[current.length] = alg;
         setAllowedSignatureAlgorithms(temp);
      }else{
         current = new String[]{alg};
         setAllowedSignatureAlgorithms(current);
      }
   }

   /**
    * @see IFBaseContext#getDigestAlgorithm()
    */
   public String getDigestAlgorithm() {
      return digestAlgorithm;
   }

   /**
    * Sets the digest-algorithm (must be used by witness and service or the protocol will definitly fail!)
    * @param digestAlgorithm
    */
   public void setDigestAlgorithm(String digestAlgorithm) {
      this.digestAlgorithm = digestAlgorithm;
   }
}
