package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

/**
 * Interface that represents some currency
 */
public interface IFCurrency {

   /**
    * Represents the currency "Counter" (used in prototype)
    */
   public static final int CURRENCY_COUNTER = 0;

   /**
    * Represents the currency "EURO" (sample)
    */
   public static final int CURRENCY_EURO = 1;

   /**
    * Represents the currency "USDOLLAR" (sample)
    */
   public static final int CURRENCY_USD = 2;

   /**
    * Default-instance representing an COUNTER-instance
    */
   public static IFCurrency CURRENCY_COUNTER_INST = new Currency();

   /**
    * Default-instance representing an EURO-instance (sample)
    */
   public static IFCurrency CURRENCY_EURO_INST = new Currency(CURRENCY_EURO);

   /**
    * Default-instance representing an USDOLLAR-instance (sample)
    */
   public static IFCurrency CURRENCY_USD_INST = new Currency(CURRENCY_USD);

   public int getCurrency();

}
