package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

/**
 * Interface that represents some amount. 
 */
public interface IFAmount {

   /**
    * Gets the amount.
    * @return the amount
    */
   public float getAmount();

   /**
    * Gets the currency of this amount.
    * @return the currency of this amount-instance
    */
   public IFCurrency getCurrency();

   /**
    * Checks wheather the current mount is below zero or not.
    * @return true if below zero, false else
    */
   public boolean isNegative();

   /**
    * Checks wheater this amount is larger than the given one (NULL-object being ignored!).
    * @param amount the amount to compare with
    * @return true if given amount is larger tha this, false else
    */
   public boolean isLargerAs(IFAmount amount);

   /**
    * Increases this amount by the given amount. The amount to increase
    * is being ignored if it is NULL and a runtime-ex is thrown if currencies
    * doesn't match.
    * @param amount2Increase amount to increase this amount
    */
   public void increase(IFAmount amount2Increase);

   /**
    * Decreases the amount by the given amount. The amount to decrease is
    * being ignored if it is NULL and a runtime-ex is thrown if currencies
    * doesn't match.
    * @param amount2Decrease amount to decrease this amount
    */
   public void decrease(IFAmount amount2Decrease);


}
