package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

import org.apache.log4j.Logger;

/**
 * Class that represents some currencyused usually within amounts.
 * @see IFAmount
 */
public class Currency implements IFCurrency{

   private static final Logger logger = Logger.getLogger(Currency.class);

   private int currency = CURRENCY_COUNTER;

   /**
    * Creates a new currency-instance (currency = CURRENCY_COUNTER)
    */
   public Currency() {
   }

   /**
    * Creates a new currency-instance with the given currency
    * @param currency currency to used
    * @see IFCurrency
    */
   public Currency(int currency) {
      this.currency = currency;
   }

   /**
    * @see IFCurrency#getCurrency()
    */
   public int getCurrency(){
      return currency;
   }

   /**
    * Checks whather this is equal to the given object or not (using currenc-ID)
    * @param obj the other currency to compare with
    * @return true if equal, false else
    */
   public boolean equals(Object obj) {
      boolean result = false;
      if(obj instanceof Currency){
         result = (getCurrency() == ((Currency)obj).getCurrency());
      }
      return result;
   }

}
