package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

import org.apache.log4j.Logger;

/**
 * Utility-class for common operations on amounts and currencies
 */
public class AmountTool {

   private static final Logger logger = Logger.getLogger(AmountTool.class);

   /**
    * Checks wheather the given amounts are equal or not.
    * @param first first amount
    * @param second second amount
    * @return true if equal, false else
    */
   public static boolean isEqual(IFAmount first, IFAmount second) {
      boolean result = false;
      if (first == null && second == null) {
         result = true;
      } else if (first == null ^ second == null) {
         result = false;
      } else if(isEqual(first.getCurrency(), second.getCurrency())) {
         if(first.getAmount() == second.getAmount()){
            result = true;
         }
      }
      return result;
   }

   /**
    * Checks wheather the given currencies are equal or not.
    * @param first first currency
    * @param second second currency
    * @return true if equal, false else
    */
   public static boolean isEqual(IFCurrency first, IFCurrency second) {
      boolean result = false;
      if (first == null && second == null) {
         result = true;
      } else if (first == null ^ second == null) {
         result = false;
      } else if(first.getCurrency() == second.getCurrency()) {
         result = true;
      }
      return result;
   }

}
