package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

import org.apache.log4j.Logger;

import javax.naming.OperationNotSupportedException;

/**
 * Class that represents some concrete amount within some account or
 * as parameter being sent via SOAP.
 */
public class Amount implements IFAmount {

   private static final Logger logger = Logger.getLogger(Amount.class);

   private float amount = 0;
   private IFCurrency currency = null;

   /**
    * Creates a new amount out of the given source-amount.
    * @param source the source-amount
    */
   public Amount(IFAmount source){
      this.amount = source.getAmount();
      this.currency = source.getCurrency();
   }

   /**
    * Creates a new amount with the given amount and currency.
    * @param amount the amount this amount should be initialized with
    * @param currency the currency of this newly created amount
    */
   public Amount(float amount, IFCurrency currency) {
      this.amount = amount;
      this.currency = currency;
   }

   /**
    * Creates an instance without amount (0) and currency (null)
    */
   public Amount() {
   }

   /**
    * @see IFAmount#getAmount()
    */
   public float getAmount() {
      return amount;
   }

   /**
    * Sets the amount
    * @param amount the amount to set
    */
   public void setAmount(float amount) {
      this.amount = amount;
   }

   /**
    * @see IFAmount#getCurrency()
    */
   public IFCurrency getCurrency() {
      return currency;
   }

   /**
    * Stes the currency for this amount.
    * @param currency the currency to set
    */
   public void setCurrency(IFCurrency currency) {
      this.currency = currency;
   }

   /**
    * @see IFAmount#increase(IFAmount)
    */
   public void increase(IFAmount amount2IncreaseBy) {
      final String fn = "[increase] ";
      if(amount2IncreaseBy != null){
         if(getCurrency().equals(amount2IncreaseBy.getCurrency())){
            amount = amount + amount2IncreaseBy.getAmount();
         }else{
            //@TODO implement Currency-Translation
            logger.error(fn + "increase by different currency not implemented yet");
            throw new RuntimeException("increase by different currency not implemented yet");
         }
      }
   }

   /**
    * @see IFAmount#decrease(IFAmount)
    */
   public void decrease(IFAmount amount2DecreaseBy) {
      final String fn = "[amount2DecreaseBy] ";
      if(amount2DecreaseBy != null){
         IFCurrency amount2DecreaseByCurr = amount2DecreaseBy.getCurrency();
         if(getCurrency().equals(amount2DecreaseByCurr)){
            amount = amount - amount2DecreaseBy.getAmount();
         }else{
            //@TODO implement Currency-Translation
            logger.error(fn + "increase by different currency not implemented yet");
            throw new RuntimeException("increase by different currency not implemented yet");
         }
      }
   }

   /**
    * @see IFAmount#isNegative()
    */
   public boolean isNegative() {
      return getAmount() < 0;
   }

   /**
    * @see IFAmount#isLargerAs(IFAmount) 
    * @param amount
    * @return
    */
   public boolean isLargerAs(IFAmount amount) {
      boolean result = true;
      if(amount != null && (amount.getAmount() >= getAmount())){
         result = false;
      }
      return result;
   }

}
