package de.tu_dresden.diplom.richter_mirko_mat2628335.common.account;

import org.apache.log4j.Logger;

/**
 * Class that represents the identification of some concrete account for add or subtract
 * some amount.
 */
public class AccountIdentification implements IFAccountIdentification{

   private static final Logger logger = Logger.getLogger(AccountIdentification.class);

   private String id = null;

   /**
    * Creates a new object.
    * @param id The id of the account to reference
    */
   public AccountIdentification(String id) {
      this.id = id;
   }

   /**
    * Creates a default instance (id="one")
    */
   public AccountIdentification() {
      id = "one";
   }

   /**
    * @see IFAccountIdentification#getId() 
    * @return
    */
   public String getId() {
      return id;
   }

   /**
    * Sets the account-id.
    * @param id the id to set
    */
   public void setId(String id) {
      this.id = id;
   }

}
