package de.tu_dresden.diplom.richter_mirko_mat2628335.common;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;

/**
 * 
 */
public class Constants {

   private static final Logger logger = Logger.getLogger(Constants.class);

   private static final Configuration conf = new Configuration(Configuration.APPLICATION_BASE);

   public static final String NS_DIGEST_ALGORITHM_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
   public static final String NS_SIGNATURE_ALGORITHM_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";

   public static final String SERVICE_ENDPOINT_WITNESS_DIGESTER = conf.getCommunicationContextLocationTomcat() + "/services/WitnessDigester";
   public static final String SERVICE_ENDPOINT_WITNESS_CONTEXT_REGISTRATOR = conf.getCommunicationContextLocationTomcat() + "/services/WitnessRegisterContext";
   public static final String SERVICE_ENDPOINT_WITNESS_INFORMATION = conf.getCommunicationContextLocationTomcat() + "/services/WitnessInfoService";
   public static final String SERVICE_ENDPOINT_WITNESS_MANAGER = conf.getCommunicationContextLocationTomcat() + "/services/WitnessManagerService";

   public static final String SERVICE_ENDPOINT_TICKET_RESERVATION = conf.getCommunicationContextLocationTomcat() + "/services/TicketReservation";
   public static final String SERVICE_ENDPOINT_TICKET_RESERVATION_CALLBACK = conf.getCommunicationContextLocationTomcat() + "/services/TicketReservationCB";

   public static final String SERVICE_ENDPOINT_TICKET_BOOKING = conf.getCommunicationContextLocationTomcat() + "/services/TicketBooking";
   public static final String SERVICE_ENDPOINT_TICKET_BOOKING_CALLBACK = conf.getCommunicationContextLocationTomcat() + "/services/TicketBookingCB";

   public static final String CLIENT1_CALLBACK = conf.getCommunicationContextLocationTomcat() + "/services/Client1CB";

   public static final String TRANSFORM_ALGORITHM_DIGEST_FULL_BODY = "http://diplom.compago.de/transformAlgorithmDigest#body";

   public static final String ELEMENT_NAME_COUNTING_CONTEXT = "CountingContext";
   public static final String ELEMENT_NAME_COORDINATION_CONTEXT = "CoordinationContext";
   public static final String ELEMENT_NAME_STEP_CONTEXT = "StepContext";

}
