package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.evidence;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFEvidenceManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFParticipantCoordinationContextEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context.IFClientContextInfo;

/**
 * Base-Interface for all client-side evidence managers
 */
public interface IFClientEvidenceManager extends IFEvidenceManager{

   /**
    * Register the evidence for the creation of a new context (signature of witness)
    * @param createdContext the context that has been returned by the witness
    * @param ccEvidence the evidence for the correct creation
    */
   public void registerSuccessfullCreatedContext(IFClientContextInfo createdContext, IFParticipantCoordinationContextEvidence ccEvidence);

   /**
    * Register the evidence for a successfull agreed digest (signature of the witness
    * over the body of the response including the agreed parameters)
    * @param contextID the context to assign this evidence to
    * @param response the response that has been sent by the witness
    * @param bodyEvidence the evidence of th digest agreement
    */
   public void registerSuccessfullAgreedDigest(String contextID, IFDigestAgreementResponse response, IFBodyEvidence bodyEvidence);
}
