package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.evidence;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.BaseEvidenceManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFParticipantCoordinationContextEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context.IFClientContextInfo;

import java.util.Map;
import java.util.HashMap;
import java.util.IdentityHashMap;

/**
 * The client-side implementation to manage the collected evidences of the communication
 */
public class ClientEvidenceManager extends BaseEvidenceManager implements IFClientEvidenceManager{

   private static final Logger logger = Logger.getLogger(ClientEvidenceManager.class);

   /**
    * maps from the context-id to the belonging IFCoordinationContext object
    */
   private Map allContexts = null;

   /**
    * maps from created context to the evidence for the creation
    */
   private Map contextCreationEvidence = null;

   /**
    * Instances may only created out of this package
    * @see ClientEvidenceManagerFactory#getClientEvidenceManager()
    */
   protected ClientEvidenceManager() {
      allContexts = new HashMap();
      contextCreationEvidence = new IdentityHashMap();
   }

   /**
    * @see IFClientEvidenceManager#registerSuccessfullCreatedContext(de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context.IFClientContextInfo, de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFParticipantCoordinationContextEvidence)
    */
   public void registerSuccessfullCreatedContext(IFClientContextInfo createdContext, IFParticipantCoordinationContextEvidence ccEvidence){
      final String fn = "[registerSuccessfullCreatedContext] ";
      if(createdContext != null && ccEvidence != null && ccEvidence.isProofed()){
         if (logger.isDebugEnabled()) logger.debug(fn + "registering successfull created context-object!");
         allContexts.put(createdContext.getIdentification(), createdContext);
         contextCreationEvidence.put(createdContext, ccEvidence);
      }else{
         logger.error(fn + "failed to register context object; Cause: PARAM NULL!");
      }
   }

   /**
    * @see IFClientEvidenceManager#registerSuccessfullAgreedDigest(String, de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse, de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence)
    */
   public void registerSuccessfullAgreedDigest(String contextID, IFDigestAgreementResponse response, IFBodyEvidence bodyEvidence){

   }

}
