package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context;

import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFContextManager;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;

/**
 * Base-Interface for all implementations of a ClientContextManager
 */
public interface IFClientContextManager extends IFContextManager{

   /**
    * Registers a newly created context to this ContextManager-implementation.
    * @param countingContext the context to be registered
    * @param handlingInfo the handlingInfo that has been created during axis-handler-chain-processing
    * @return the internal representation of the context 
    */
   public IFClientContextInfo registerContext(IFCountingContext countingContext, IFHandlingInfo handlingInfo);

}
