package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context;

import org.apache.log4j.Logger;

/**
 * Factory to obtain the ClientContextManager-instance from (currently implemented
 * as singleton)
 */
public class ClientContextManagerFactory {

   private static final Logger logger = Logger.getLogger(ClientContextManagerFactory.class);

   private static IFClientContextManager clientContextManager = null;

   /**
    * Gets the ClientContextManager-instance
    * @return the instance
    */
   public static IFClientContextManager getContextManager(){
      if(clientContextManager == null){
         clientContextManager = new ClientContextManager();
      }
      return clientContextManager;
   }

}
