package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.*;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementResponse;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.digestAgreement.IFDigestAgreementRequest;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.evidence.IFBodyEvidence;
import de.tu_dresden.diplom.richter_mirko_mat2628335.clients.evidence.ClientEvidenceManagerFactory;

import java.util.*;

/**
 * The class hat is responsible for managing the contexts that are in use by the client.
 */
public class ClientContextManager extends BaseContextManager implements IFClientContextManager {

   private static final Logger logger = Logger.getLogger(ClientContextManager.class);
   public static final Logger contextStateMonitor = Logger.getLogger("monitor.state.context.client");
   //public static final Logger digestAgreementStateMonitor = Logger.getLogger("monitor.state.digestAgreement.client");
   //public static final Logger communicationStateMonitor = Logger.getLogger("monitor.state.communication.client");

   /**
    * Creation only allowed out of the same package
    * @see ClientContextManagerFactory#getContextManager() 
    */
   protected ClientContextManager() {

   }

   /**
    * @see de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.BaseContextManager#getInheritedLogger()
    * @return the logger of this class
    */
   public Logger getInheritedLogger() {
      return logger;
   }

   /**
    * @see IFClientContextManager#registerContext(de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext, de.tu_dresden.diplom.richter_mirko_mat2628335.common.handler.data.IFHandlingInfo) 
    */
   public synchronized IFClientContextInfo registerContext(IFCountingContext countingContext, IFHandlingInfo handlingInfo) {
      final String fn = "[registerContext] ";
      IFClientContextInfo result = null;
      if (countingContext != null &&
           countingContext.getCoordinationContext() != null &&
           countingContext.getCoordinationContext().getIdentification() != null &&
           countingContext.getCoordinationContext().getIdentification().length() > 0) {
         result = new ClientContextInfo(countingContext);
         if (logger.isDebugEnabled()) logger.debug(fn + "suceesfully registered new ClientContextInfo-Object");
         addContext(countingContext.getIdentification(), result);
      } else {
         logger.error(fn + "couldn't register the new ClientContextInfo-Object; Cause: PARAM NULL!");
      }
      logRegisteredContextsToMonitor(fn);
      return result;
   }

   private void logRegisteredContextsToMonitor(final String fn) {
      if (contextStateMonitor.isDebugEnabled()) {
         StringBuffer mon = new StringBuffer(fn);
         mon.append(getContextInfoObjectsCount()).append(" registered ClientContextInfos").append("\n");
         int counter = 1;
         Iterator iterator = getContextInfoObjectsIterator();
         for (; iterator.hasNext();) {
            IFContextInfo info = (IFContextInfo) iterator.next();
            mon.append("\tClientContextInfo_").append(counter).append(": \n");
            mon.append("\t\tIdentification: ").append(info.getIdentification()).append("\n");
            counter++;
         }
         contextStateMonitor.debug(mon);

      }
   }

}
