package de.tu_dresden.diplom.richter_mirko_mat2628335.clients.context;

import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCoordinationContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.IFCountingContext;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.context.BaseContextInfo;

/**
 * Class that represents a local context within the data of the client (actually
 * contains all the data that has been transferred by the witness as a response
 * on a contextCreation-Request).
 */
public class ClientContextInfo extends BaseContextInfo implements IFClientContextInfo{

   private static final Logger logger = Logger.getLogger(ClientContextInfo.class);

   /**
    * The context-representation
    */
   private IFCountingContext countingContext = null;

   /**
    * Creates a new Object out of the given (ransferred by witness) context-data.
    * @param countingContext
    */
   public ClientContextInfo(IFCountingContext countingContext) {
      this.countingContext = countingContext;
   }

   /**
    * Gets the unique identification of this context-object.
    * @return
    */
   public String getIdentification() {
      String result = null;
      if(countingContext != null && countingContext.getCoordinationContext() != null){
         result = countingContext.getCoordinationContext().getIdentification();
      }
      return result;
   }
}
