package de.tu_dresden.diplom.richter_mirko_mat2628335;

import org.apache.log4j.Logger;
import org.apache.axis.client.AdminClient;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * 
 */
public class DeployServices {

   private static final Logger logger = Logger.getLogger(DeployServices.class);

   public static void main(String[] args){
      AdminClient client = new AdminClient();
      Configuration conf = new Configuration(Configuration.APPLICATION_MODULES_BASE);
      try {
         client.setTargetEndpointAddress(new URL(conf.getDeploymentAdminServiceLocation()));
         String webInfDir = conf.getModuleUsageCounterHome() + "/WEB-INF";
         String deploymentServiceOption = "-l" + conf.getDeploymentServiceLocation();
         client.process(new String[]{deploymentServiceOption, webInfDir + "/witness_deploy.wsdd"});
         client.process(new String[]{deploymentServiceOption, webInfDir + "/ticketReservation_deploy.wsdd"});
         client.process(new String[]{deploymentServiceOption, webInfDir + "/ticketBooking_deploy.wsdd"});
         client.process(new String[]{deploymentServiceOption, webInfDir + "/witnessInfoService_deploy.wsdd"});
         client.process(new String[]{deploymentServiceOption, webInfDir + "/witnessManagementService_deploy.wsdd"});
      } catch (MalformedURLException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (Exception e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }

}
