package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceWitness.bindingsWitness;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.*;
import org.systinet.uddi.InvalidParameterException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.Base;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.keystore.ApplicationSpecificKeystoreUtility;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

import sun.misc.BASE64Encoder;

/**
 * Creates the BindingTemplate for the WitnessContextRegistrator-Service.
 */
public class ContextRegistrator {

   private static final Logger logger = Logger.getLogger(ContextRegistrator.class);

   /**
    * Gets the binding.
    * @return The Binding for the contextRegistrator-service.
    * @throws InvalidParameterException
    */
   public BindingTemplate getBinding() throws InvalidParameterException {
      BindingTemplate result = new BindingTemplate();
      result.setAccessPoint(new AccessPoint(DiplomaCooperation.CONTEXT_REGISTRATOR_ACCESSPOINT));
      result.setBindingKey(DiplomaCooperation.CONTEXT_REGISTRATOR_KEY);
      TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
      InstanceDetails details = new InstanceDetails();
      details.setInstanceParms(getContextRegistratorCerts());
      instanceInfo.setTModelKey(Base.CERTIFICATE_TAXONOMY_TMODEL_KEY);
      instanceInfo.setInstanceDetails(details);
      result.addTModelInstanceInfo(instanceInfo);
      return result;
   }

   /**
    * Creates a String out of the certificates needed for the Digester-Service bounded by
    * -----BEGIN CERTIFICATE----- and -----END CERTIFICATE-----.
    * @return
    */
   private String getContextRegistratorCerts(){
      StringBuffer result = new StringBuffer();
      try {
         BASE64Encoder myB64 = new BASE64Encoder();
         Certificate witnessCert = ApplicationSpecificKeystoreUtility.getCertificate4Signature(ApplicationSpecificKeystoreUtility.ENTITY_WITNESS);
         result.append("-----BEGIN CERTIFICATE-----\n");
         result.append(myB64.encode(witnessCert.getEncoded()));
         result.append("\n-----END CERTIFICATE-----\n");
         Certificate witnessDigesterCert = ApplicationSpecificKeystoreUtility.getCertificate4Encryption(ApplicationSpecificKeystoreUtility.ENTITY_WITNESS_CONTEXT_REGISTRATOR);
         result.append("-----BEGIN CERTIFICATE-----\n");
         result.append(myB64.encode(witnessDigesterCert.getEncoded()));
         result.append("\n-----END CERTIFICATE-----");
      } catch (CertificateEncodingException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
         result = new StringBuffer("");
      }
      return result.toString();
   }

}
