package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceWitness;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.InvalidParameterException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceWitness.bindingsWitness.ContextRegistrator;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceWitness.bindingsWitness.Digester;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;

/**
 * Creates the BusinessService for the Witness.
 */
public class WitnessService {

   private static final Logger logger = Logger.getLogger(WitnessService.class);

   /**
    * Gets the service.
    * @return The service of the witness.
    * @throws InvalidParameterException
    */
   public BusinessService getService() throws InvalidParameterException {
      BusinessService service = new BusinessService();
      service.addName(new Name(DiplomaCooperation.WITNESS_SERVICE_NAME));
      service.setServiceKey(DiplomaCooperation.WITNESS_SERVICE_KEY);
      service.addDescription(new Description("The Witness-Service"));
      service.addBindingTemplate(new ContextRegistrator().getBinding());
      service.addBindingTemplate(new Digester().getBinding());
      return service;
   }

}
