package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceTicket.bindingsTicket;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.AccessPoint;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfo;
import org.systinet.uddi.client.v3.struct.InstanceDetails;
import org.systinet.uddi.InvalidParameterException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.Base;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.keystore.ApplicationSpecificKeystoreUtility;
import sun.misc.BASE64Encoder;

import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

/**
 * Creates the BindingTemplate for the TicketBooking-Service.
 */
public class Booking {

   private static final Logger logger = Logger.getLogger(Booking.class);

   /**
    * Gets the binding.
    * @return The Binding for the ticketBooking-service.
    * @throws org.systinet.uddi.InvalidParameterException
    */
   public BindingTemplate getBinding() throws InvalidParameterException {
      BindingTemplate result = new BindingTemplate();
      result.setAccessPoint(new AccessPoint(DiplomaCooperation.TICKET_BOOKING_ACCESSPOINT));
      result.setBindingKey(DiplomaCooperation.TICKET_BOOKING_KEY);
      TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
      InstanceDetails details = new InstanceDetails();
      details.setInstanceParms(getTicketBookingCerts());
      instanceInfo.setTModelKey(Base.CERTIFICATE_TAXONOMY_TMODEL_KEY);
      instanceInfo.setInstanceDetails(details);
      result.addTModelInstanceInfo(instanceInfo);
      return result;
   }

   /**
    * Creates a String out of the certificates needed for the Digester-Service bounded by
    * -----BEGIN CERTIFICATE----- and -----END CERTIFICATE-----.
    * @return
    */
   private String getTicketBookingCerts() {
      StringBuffer result = new StringBuffer();
      try {
         BASE64Encoder myB64 = new BASE64Encoder();
         Certificate witnessCert = ApplicationSpecificKeystoreUtility.getCertificate4Signature(ApplicationSpecificKeystoreUtility.ENTITY_TICKET_SERVICE);
         result.append("-----BEGIN CERTIFICATE-----\n");
         result.append(myB64.encode(witnessCert.getEncoded()));
         result.append("\n-----END CERTIFICATE-----\n");
         Certificate witnessDigesterCert = ApplicationSpecificKeystoreUtility.getCertificate4Encryption(ApplicationSpecificKeystoreUtility.ENTITY_TICKET_BOOKING);
         result.append("-----BEGIN CERTIFICATE-----\n");
         result.append(myB64.encode(witnessDigesterCert.getEncoded()));
         result.append("\n-----END CERTIFICATE-----");
      } catch (CertificateEncodingException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
         result = new StringBuffer("");
      }
      return result.toString();
   }

}
