package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceTicket;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.InvalidParameterException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceTicket.bindingsTicket.Booking;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceTicket.bindingsTicket.Reservation;

/**
 * Creates the BusinessService for the TicketService
 */
public class TicketService {

   private static final Logger logger = Logger.getLogger(TicketService.class);

   /**
    * Gets the service.
    * @return The service of the witness.
    * @throws org.systinet.uddi.InvalidParameterException
    */
   public BusinessService getService() throws InvalidParameterException {
      BusinessService service = new BusinessService();
      service.addName(new Name(DiplomaCooperation.TICKET_SERVICE_NAME));
      service.setServiceKey(DiplomaCooperation.TICKET_SERVICE_KEY);
      service.addDescription(new Description("The Ticket-Service"));
      service.addBindingTemplate(new Booking().getBinding());
      service.addBindingTemplate(new Reservation().getBinding());
      return service;
   }
}

