package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.*;
import org.systinet.uddi.InvalidParameterException;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceWitness.WitnessService;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.serviceTicket.TicketService;
import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.Base;
import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;

/**
 * Creates the business for the fictive DIPLOMA COOPERATION.
 */
public class DiplomaCooperation {

   private static final Logger logger = Logger.getLogger(DiplomaCooperation.class);

   private static final Configuration conf = new Configuration(Configuration.APPLICATION_BASE);

   /**
    * Name of the DIPLOMA COOPERATION that should be used in the UDDI registry.
    */
   public static final String BUSINESS_DIPLOMA_COOP_NAME = "Diploma Cooperation";

   /**
    * Key op the DIPLOMA COOPERATION business (as of UDDIv3)
    */
   public static final String BUSINESS_DIPLOMA_COOP_KEY = Base.UDDI_NAMESPACE + "::business:diploma-coop";

   /**
    * Name of the Witness-Service that should be used in the UDDi registry.
    */
   public static final String WITNESS_SERVICE_NAME = "Witness Service";

   /**
    * Key of the Witness-Service (as of UDDI v3)
    */
   public static final String WITNESS_SERVICE_KEY = BUSINESS_DIPLOMA_COOP_KEY + "::service:witness";

   /**
    * AccesPoint (URL) for the ContextRegistrator
    */
   public static final String CONTEXT_REGISTRATOR_ACCESSPOINT = conf.getCommunicationContextLocationTomcat() + "/services/WitnessRegisterContext";

   /**
    * Key of the bindingTemplate "ContextRegistrator" (as of UDDiv3)
    */
   public static final String CONTEXT_REGISTRATOR_KEY = WITNESS_SERVICE_KEY + "::binding:contextRegistrator";

   /**
    * AccesPoint (URL) for the Digester
    */
   public static final String DIGESTER_ACCESSPOINT = conf.getCommunicationContextLocationTomcat() + "/services/WitnessDigester";

   /**
    * Key of the bindingTemplate "Digester" (as of UDDiv3)
    */
   public static final String DIGESTER_KEY = WITNESS_SERVICE_KEY + "::binding:digester";

   /**
    * Name of the Ticket-Service that should be used in the UDDi registry.
    */
   public static final String TICKET_SERVICE_NAME = "Ticket Service";

   /**
    * Key of the Ticket-Service (as of UDDI v3)
    */
   public static final String TICKET_SERVICE_KEY = BUSINESS_DIPLOMA_COOP_KEY + "::service:ticket";

   /**
    * AccesPoint (URL) for the TicketReservation
    */
   public static final String TICKET_RESERVATION_ACCESSPOINT = conf.getCommunicationContextLocationTomcat() + "/services/TicketReservation";

   /**
    * Key of the bindingTemplate "TicketReservation" (as of UDDiv3)
    */
   public static final String TICKET_RESERVATION_KEY = WITNESS_SERVICE_KEY + "::binding:ticketReservation";

   /**
    * AccesPoint (URL) for the TicketBooking
    */
   public static final String TICKET_BOOKING_ACCESSPOINT = conf.getCommunicationContextLocationTomcat() + "/services/TicketBooking";

   /**
    * Key of the bindingTemplate "TicketBooking" (as of UDDiv3)
    */
   public static final String TICKET_BOOKING_KEY = WITNESS_SERVICE_KEY + "::binding:ticketBooking";

   /**
    * Gets the business.
    * @return The business of DIPLOMA COOPERATION.
    * @throws InvalidParameterException
    */
   public BusinessEntity getBusiness() throws InvalidParameterException {
      final String fn = "[getBusiness] ";
      if (logger.isDebugEnabled()) logger.debug(fn + "Creating Business '" + BUSINESS_DIPLOMA_COOP_NAME + "' with key '" + BUSINESS_DIPLOMA_COOP_KEY + "' ...");
      BusinessEntity newBusiness = new BusinessEntity();
      newBusiness.addName(new Name(BUSINESS_DIPLOMA_COOP_NAME));
      newBusiness.setBusinessServiceArrayList(getBusinessServices());
      newBusiness.setBusinessKey(BUSINESS_DIPLOMA_COOP_KEY);
      newBusiness.setDescriptionArrayList(getDescriptions());
      if (logger.isDebugEnabled()) logger.debug(fn + "... Done");
      return newBusiness;
   }

   /**
    * Generates the description of the business.
    * @return
    * @throws InvalidParameterException
    */
   private DescriptionArrayList getDescriptions() throws InvalidParameterException {
      DescriptionArrayList result = new DescriptionArrayList();
      result.add(new Description("Prototypical business for the Diploma Thesis of Mirko Richter - Matr.Nr.: 2628335"));
      return result;
   }

   /**
    * Generates all services that should belinked to business DIPLOMA COOPERATION.
    * @return
    * @throws InvalidParameterException
    */
   private BusinessServiceArrayList getBusinessServices() throws InvalidParameterException {
      final String fn = "[getBusinessServices] ";
      if (logger.isDebugEnabled()) logger.debug(fn + "Adding Services ...");
      BusinessServiceArrayList result = new BusinessServiceArrayList();
      result.add(new WitnessService().getService());
      result.add(new TicketService().getService());
      if (logger.isDebugEnabled()) logger.debug(fn + "... Done");
      return result;
   }

}
