package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.*;
import org.systinet.uddi.client.v3.UDDIException;
import org.systinet.uddi.InvalidParameterException;

import javax.xml.soap.SOAPException;
import java.util.Iterator;

import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;

/**
 * Class that is used to remove the structure that has been created for our
 * prototyps
 */
public class UDDIStructureRemover extends Base {

   private static final Logger logger = Logger.getLogger(UDDIStructureRemover.class);

   /**
    * Convinient method to remove the structure
    */
   public void removeStructure(){
      try {
         removeCertificateTModel();
         removeBusinesses();
      } catch (InvalidParameterException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (UDDIException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (SOAPException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }

   /**
    * Removes the business DIPLOMA COOPERATION from the UDDI registry.
    * @throws InvalidParameterException
    * @throws UDDIException
    * @throws SOAPException
    */
   private void removeBusinesses() throws InvalidParameterException, UDDIException, SOAPException {
      final String fn = "[removeBusinesses] ";
      if (logger.isDebugEnabled()) logger.debug(fn + "Removing Business '" + DiplomaCooperation.BUSINESS_DIPLOMA_COOP_KEY + "'");
      Delete_business deleter = new Delete_business();
      deleter.addBusinessKey(DiplomaCooperation.BUSINESS_DIPLOMA_COOP_KEY);
      deleter.setAuthInfo(getAuthInfo());
      getPublishStub().delete_business(deleter);
      if (logger.isDebugEnabled()) logger.debug(fn + "... Done");
   }

   /**
    * Removes our tModel that represents the certificate-classification from the UDDI-Registry
    * @throws InvalidParameterException
    * @throws UDDIException
    * @throws SOAPException
    */
   private void removeCertificateTModel() throws InvalidParameterException, UDDIException, SOAPException {
      final String fn = "[removeCertificateTModel] ";
      if (logger.isDebugEnabled()) logger.debug(fn + "Removing tModel '" + CERTIFICATE_TAXONOMY_TMODEL_KEY + "' ...");
      Delete_tModel deleter = new Delete_tModel();
      deleter.addTModelKey(CERTIFICATE_TAXONOMY_TMODEL_KEY);
      deleter.setAuthInfo(getAuthInfo());
      getPublishStub().delete_tModel(deleter);
      if (logger.isDebugEnabled()) logger.debug(fn + "... Done");
   }
}
