package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.struct.*;
import org.systinet.uddi.client.v3.*;
import org.systinet.uddi.client.v3.ext.UDDIPublishStub;
import org.systinet.uddi.InvalidParameterException;

import javax.xml.soap.SOAPException;

import java.util.Iterator;

import de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation.businessDiplCoop.DiplomaCooperation;

/**
 * Creates the UDDI-structures (tModel, business, service, bindingTemplate) that are needed
 * by the prototyps "authenticating webservices" and "usage counter ws-access"
 */
public class UDDIStructureCreator extends Base{

   private static final Logger logger = Logger.getLogger(UDDIStructureCreator.class);

   /**
    * Convenient method to create the target-structure
    */
   public void createStructure(){
      try {
         //test.printTModelList(types);
         //TModel createdCategoryTModel = createCertificateTModel();
         createBusiness();
      } catch (SOAPException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (UDDIException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (InvalidParameterException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }

   /**
    * Creates the Business (DIPLOMA COOPERATION + 2 Services with 2 bindingTemplates each).
    * @throws InvalidParameterException
    * @throws SOAPException
    * @throws UDDIException
    */
   private void createBusiness() throws InvalidParameterException, SOAPException, UDDIException {
      Save_business business2save = new Save_business();
      business2save.addBusinessEntity(new DiplomaCooperation().getBusiness());
      business2save.setAuthInfo(getAuthInfo());
      getPublishStub().save_business(business2save);
   }

   /**
    * creates the tModel for the categorization system "certificate" and writes it to the UDDI.
    * @return
    * @throws SOAPException
    * @throws UDDIException
    * @throws InvalidParameterException
    */
   private TModel createCertificateTModel() throws SOAPException, UDDIException, InvalidParameterException {
      final String fn = "[createCertificateTModel]";
      if (logger.isDebugEnabled()) logger.debug(fn + "Creating tModel '" + CERTIFICATE_TAXONOMY_NAME + "' ...");
      TModel result = null;
      Save_tModel saver = new Save_tModel();
      TModel tModel = new TModel();
      CategoryBag categoryBag = new CategoryBag();
      KeyedReference reference = new KeyedReference();
      if (logger.isDebugEnabled()) logger.debug(fn + "... setting reference to '" + BASE_CATEGORIZATION_TYPES + "' ...");
      reference.setTModelKey(BASE_CATEGORIZATION_TYPES);
      //reference.setKeyName("Categorization System");
      reference.setKeyName("Certificate System");
      reference.setKeyValue("categorization");
      //reference.setKeyValue("certificate type");
      categoryBag.addKeyedReference(reference);
      tModel.setCategoryBag(categoryBag);
      tModel.setName(new Name(CERTIFICATE_TAXONOMY_NAME));
      tModel.setTModelKey(CERTIFICATE_TAXONOMY_TMODEL_KEY);
      saver.addTModel(tModel);
      saver.setAuthInfo(getAuthInfo());
      TModelDetail detail = getPublishStub().save_tModel(saver);
      if(detail.getTModelArrayList().size() > 1 || detail.getTModelArrayList().size() < 1){
         logger.error(fn + " create operation returned morethan one or zero results!");
      }else{
         result = detail.getTModelArrayList().get(0);
      }
      return result;
   }
}
