package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import de.tu_dresden.diplom.richter_mirko_mat2628335.common.keystore.ApplicationSpecificKeystoreUtility;
import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;

import java.security.cert.*;
import java.security.PrivateKey;
import java.io.File;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;

import sun.misc.BASE64Encoder;

/**
 * Class sthat initiates base-operations on the UDDI-Registry
 */
public class Main {

   private static final Logger logger = Logger.getLogger(Main.class);

   public static void main(String[] args) {
      BasicConfigurator.configure();
      createStructure();
      printStructure();
//      removeStructure();
//      writeSigningCertsAndKeys2File();
//      UDDI uddi = new UDDI();
//      uddi.getTicketReservationEntry().getLastCertificate();
   }

   /**
    * removes the created structure from the registry
    */
   private static void removeStructure() {
      UDDIStructureRemover remover = new UDDIStructureRemover();
      remover.removeStructure();
   }

   /**
    * prints the created structure
    */
   private static void printStructure() {
      final String fn = "[printStructure] ";
      if (logger.isDebugEnabled()) logger.debug(fn + "Printing structure ...");
      UDDIStructurePrinter printer = new UDDIStructurePrinter();
      printer.printStructure();
      if (logger.isDebugEnabled()) logger.debug(fn + "... done");
   }

   /**
    * creates our structure
    */
   private static void createStructure() {
      UDDIStructureCreator structureCreator = new UDDIStructureCreator();
      structureCreator.createStructure();
   }

   /**
    * Creates files from certificates and private keys (not supported by keytool) in PEM-Style
    * and writes them to disk (be sure to configure the settings within this method properly before using).
    */
   private static void writeSigningCertsAndKeys2File(){
      //writeCertAndKey2File(ApplicationSpecificKeystoreUtility.ENTITY_CA, "ca");
      writeCertAndKey2File(ApplicationSpecificKeystoreUtility.ENTITY_TICKET_SERVICE, "ticketservice");
      writeCertAndKey2File(ApplicationSpecificKeystoreUtility.ENTITY_WITNESS, "witness");
   }

   /**
    * writes PEM-files
    * @param entity Entity-ID (application-specific) to write the certs/priv key from
    * @param filePre Prefix of the files being created (ending with "key.pem" or "cert.pem")
    * @see ApplicationSpecificKeystoreUtility
    */
   private static void writeCertAndKey2File(int entity, String filePre){
      //int entityToExport = ApplicationSpecificKeystoreUtility.ENTITY_TICKET_SERVICE;
      Configuration conf = new Configuration(Configuration.APPLICATION_BASE);
      try {
         PrivateKey caPrivKey = ApplicationSpecificKeystoreUtility.getPrivateKey4Signature(entity);
         File file = new File(conf.getCertHome() + "/" + filePre + "key.pem");
         BASE64Encoder myB64 = new BASE64Encoder();
         String b64 = myB64.encode(caPrivKey.getEncoded());
         PrintWriter printer = new PrintWriter(new FileOutputStream(file));
         printer.println("-----BEGIN PRIVATE KEY-----");
         printer.println(b64);
         printer.println("-----END PRIVATE KEY-----");
         printer.close();
         Certificate caCert = ApplicationSpecificKeystoreUtility.getCertificate4Signature(entity);
         file = new File(conf.getCertHome() + "/" + filePre + "cert.pem");
         b64 = myB64.encode(caCert.getEncoded());
         printer = new PrintWriter(new FileOutputStream(file));
         printer.println("-----BEGIN CERTIFICATE-----");
         printer.println(b64);
         printer.println("-----END CERTIFICATE-----");
         printer.close();
      } catch (FileNotFoundException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      } catch (CertificateEncodingException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }



}
