package de.tu_dresden.diplom.richter_mirko_mat2628335.uddipopulation;

import org.apache.log4j.Logger;
import org.systinet.uddi.client.v3.*;
import org.systinet.uddi.client.v3.struct.Get_authToken;
import org.systinet.uddi.client.v3.ext.UDDIPublishStub;
import org.systinet.uddi.InvalidParameterException;

import javax.xml.soap.SOAPException;

import de.tu_dresden.diplom.richter_mirko_mat2628335.Configuration;

/**
 * Base-class that configures all communication with the systinet UDDI-registry
 */
public class Base {

   private static final Logger logger = Logger.getLogger(Base.class);

   Configuration conf = new Configuration(Configuration.APPLICATION_BASE);

   /**
    * Base-Part of all namespaces created during Prototyp-creation (UDDI-keys)
    */
   public static final String UDDI_NAMESPACE = "uddi:tu-dresden:diplom:richter-mirko-mat2628335";

   /**
    * Name of the tModel-taxonomy that is being created to classify bindingTemplates
    * that specify certificates (technical fingerprint!)
    */
   public static final String CERTIFICATE_TAXONOMY_NAME = "diplom:mr22:certificate";

   /**
    * Key of the tModel-taxonomy as being used in the registry
    */
   public static final String CERTIFICATE_TAXONOMY_TMODEL_KEY = UDDI_NAMESPACE + "::taxonomy:certificate";

   /**
    * Name of the key in the UDDi-registry that declares some type as TYPE.
    */
   public static final String BASE_CATEGORIZATION_TYPES = "uddi:uddi.org:categorization:types";

   /**
    * Returns the InquiryStub for the UDDI
    *
    * @return
    * @throws javax.xml.soap.SOAPException
    */
   protected UDDI_Inquiry_PortType getInquiryStub()
        throws SOAPException {
      final String fn = "[getInquiryStub] ";
      String url = conf.getCommunicationContextLocationSystinet() + "/inquiry";
      if (logger.isDebugEnabled()) logger.debug(fn + "Using URL '" + url + "' for creation of inquiry-Stub ...");
      //String url = "http://gandalf:8088/uddi/inquiry";
      UDDI_Inquiry_PortType inquiry = UDDIInquiryStub.getInstance(url);
      if (logger.isDebugEnabled()) logger.debug(fn + "... done");
      return inquiry;
   }

   /**
    * Returns the PublishStub for the UDDI
    *
    * @return
    * @throws SOAPException
    */
   protected UDDI_Publication_PortType getPublishStub()
        throws SOAPException {
      final String fn = "[getPublishStub] ";
      String url = conf.getCommunicationContextLocationSystinet() + "/publishing";
      if (logger.isDebugEnabled()) logger.debug(fn + "Using URL '" + url + "' for creation of publishing-Stub ...");
      //String url = "http://gandalf:8088/uddi/publishing";
      UDDI_Publication_PortType publication = UDDIPublishStub.getInstance(url);
      if (logger.isDebugEnabled()) logger.debug(fn + "... done");
      return publication;
   }

   /**
    * Returns the SecurityStub for the UDDI
    *
    * @return
    * @throws SOAPException
    */
   protected UDDI_Security_PortType getSecurityStub()
        throws SOAPException {
      final String fn = "[getSecurityStub] ";
      //String url = "http://gandalf:8088/uddi/security";
      String url = conf.getCommunicationContextLocationSystinet() + "/security";
      if (logger.isDebugEnabled()) logger.debug(fn + "Using URL '" + url + "' for creation of security-Stub ...");
      UDDI_Security_PortType security = UDDISecurityStub.getInstance(url);
      if (logger.isDebugEnabled()) logger.debug(fn + "... done");
      return security;
   }

   /**
    * Communicates with the UDDI-registry on request for some authInfo and returnes the
    * string that was returned by the registry
    * @return the authentication token
    * @throws SOAPException
    * @throws InvalidParameterException
    * @throws UDDIException
    */
   protected String getAuthInfo() throws SOAPException, InvalidParameterException, UDDIException {
      String result = null;
      result = getSecurityStub().get_authToken(new Get_authToken("admin", "changeit")).getAuthInfo();
      return result;
   }
}
