/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.AclList;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.Policy;
import com.ibm.xml.policy.xacl.Rule;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Xacl {
    private final Policy m_Policy;
    private final Rule[] m_Rule;
    private final String m_Id;
    private final short m_Precedence;
    private final Vector m_ObjectVector;
    private final String[] m_ObjectHref;

    Xacl(Element elem, Policy policy) throws XaclException {
        Vector vec;
        int xaclRuleNum;
        int i;
        this.m_Policy = policy;
        this.m_Id = elem.getAttribute("id");
        this.m_Precedence = elem.getAttribute("precedence") == null || elem.getAttribute("precedence").equals("") ? (short)Short.MAX_VALUE : new Short(elem.getAttribute("precedence"));
        this.m_ObjectVector = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "object");
        int objNum = this.m_ObjectVector.size();
        if (objNum > 0) {
            this.m_ObjectHref = new String[objNum];
            for (i = 0; i < objNum; ++i) {
                this.m_ObjectHref[i] = ((Element)this.m_ObjectVector.elementAt(i)).getAttribute("href");
            }
        } else {
            this.m_ObjectHref = null;
        }
        if ((xaclRuleNum = (vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "rule")).size()) > 0) {
            this.m_Rule = new Rule[xaclRuleNum];
            for (i = 0; i < xaclRuleNum; ++i) {
                this.m_Rule[i] = new Rule((Element)vec.elementAt(i), this);
            }
        } else {
            this.m_Rule = null;
        }
    }

    Policy getPolicy() {
        return this.m_Policy;
    }

    Rule[] getRules() {
        return this.m_Rule;
    }

    short getPrecedenceValue() {
        return this.m_Precedence;
    }

    String[] getObjects() {
        return this.m_ObjectHref;
    }

    Node[] getTargetNodes(DOMHandler targetDocHandler) throws XaclException {
        int j;
        int i;
        int nodeNum = 0;
        int count = 0;
        NodeList[] targetNodeList = new NodeList[this.m_ObjectHref.length];
        for (i = 0; i < this.m_ObjectHref.length; ++i) {
            try {
                targetNodeList[i] = XPathAPI.selectNodeList((Node)targetDocHandler.getDocument(), (String)this.m_ObjectHref[i], (Node)((Element)this.m_ObjectVector.elementAt(i)));
            }
            catch (Exception e) {
                throw new XaclException(201, "while importing the policy (" + this.m_ObjectHref[i] + ")");
            }
            for (j = 0; j < targetNodeList[i].getLength(); ++j) {
                Attr attr;
                if (targetNodeList[i].item(j).getNodeType() != 1 && targetNodeList[i].item(j).getNodeType() != 2) {
                    throw new XaclException(210, "(" + this.m_ObjectHref[i] + ")");
                }
                if (targetNodeList[i].item(j).getNodeType() != 2 || !(attr = (Attr)targetNodeList[i].item(j)).getName().equals("xmlns") && !attr.getName().startsWith("xmlns:")) continue;
                throw new XaclException(211, "(" + this.m_ObjectHref[i] + ")");
            }
            if (targetNodeList[i] != null) {
                nodeNum += targetNodeList[i].getLength();
                continue;
            }
            throw new XaclException(201, "while importing the policy (" + this.m_ObjectHref[i] + ")");
        }
        Node[] targetNodeArray = new Node[nodeNum];
        for (i = 0; i < this.m_ObjectHref.length; ++i) {
            if (targetNodeList[i] == null) continue;
            for (j = 0; j < targetNodeList[i].getLength(); ++j) {
                targetNodeArray[count + j] = targetNodeList[i].item(j);
            }
            count += targetNodeList[i].getLength();
        }
        return targetNodeArray;
    }

    void matching(AccessRequest accessReq, Node query, AclList aclList, DOMHandler targetDocHandler, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context, String searched_permission) throws XaclException {
        for (int i = 0; i < this.m_Rule.length; ++i) {
            this.m_Rule[i].matching(accessReq, query, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, searched_permission);
        }
    }

    void indexing(Hashtable ht, Document target, Hierarchy rh, Hierarchy gh) {
        for (int i = 0; i < this.m_Rule.length; ++i) {
            this.m_Rule[i].indexing(ht, target, rh, gh);
        }
    }
}

