/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.DOMSource;
import com.ibm.xml.policy.util.ErrorHandlerImpl;
import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.DecisionList;
import com.ibm.xml.policy.xacl.Evaluator;
import com.ibm.xml.policy.xacl.Executor;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.HierarchyImpl;
import com.ibm.xml.policy.xacl.Policy;
import com.ibm.xml.policy.xacl.XACLProcessor;
import com.ibm.xml.policy.xacl.XaclException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class XACLProcessorImpl
extends XACLProcessor {
    static final String m_Version = "XACLProcessor Version 1.3 (August 23, 2002)";
    static final boolean attr_wise_ac_support = true;
    private final Policy m_Policy;
    private final DOMHandler m_TargetDocHandler;
    private final Element m_StatusElem;
    private final Hierarchy m_RoleHierarchy;
    private final Hierarchy m_GroupHierarchy;

    public XACLProcessorImpl(Document targetDoc, Element policyElem, Element statusElem, Hierarchy roleHierarchy, Hierarchy groupHierarchy) throws XaclException {
        this.m_Policy = new Policy(policyElem);
        this.m_TargetDocHandler = new DOMHandler(targetDoc);
        this.m_Policy.createNode2XaclTable(this.m_TargetDocHandler);
        this.m_StatusElem = statusElem;
        this.m_RoleHierarchy = roleHierarchy;
        this.m_GroupHierarchy = groupHierarchy;
    }

    public static String getVersion() {
        return m_Version;
    }

    public DecisionList[] process(Element[] accessReqElem, Object context) throws XaclException {
        DocumentType docType = null;
        String flag = System.getProperty("com.ibm.xml.policy.removeDocType", "true");
        if (flag.toLowerCase().equals("true") && (docType = this.m_TargetDocHandler.getDocument().getDoctype()) != null) {
            this.m_TargetDocHandler.getDocument().removeChild(docType);
        }
        DecisionList[] decisionList = new DecisionList[accessReqElem.length];
        Evaluator eva = new Evaluator();
        Executor exe = new Executor();
        for (int i = 0; i < accessReqElem.length; ++i) {
            AccessRequest accessReq = new AccessRequest(accessReqElem[i]);
            accessReq.setTargetDocumentHandler(this.m_TargetDocHandler);
            if (accessReq.getTargetNodeXPath() == null) {
                throw new XaclException(204, "when starting the policy evaluation.");
            }
            if (accessReq.getAction() == null) {
                throw new XaclException(604, "when starting the policy evaluation.");
            }
            decisionList[i] = eva.evaluate(accessReq, this.m_TargetDocHandler, this.m_Policy, this.m_StatusElem, this.m_RoleHierarchy, this.m_GroupHierarchy, context);
            exe.execute(decisionList[i], this.m_TargetDocHandler, this.m_StatusElem, context);
            if (!accessReq.getType().equals("execute")) continue;
            this.m_Policy.createNode2XaclTable(this.m_TargetDocHandler);
        }
        if (flag.toLowerCase().equals("true") && docType != null) {
            this.m_TargetDocHandler.getDocument().appendChild(docType);
        }
        return decisionList;
    }

    public static DecisionList process(Element accessReqElem, Document targetDoc, Element policyElem, Element statusElem, Hierarchy roleHierarchy, Hierarchy groupHierarchy) throws XaclException {
        Element[] elem = new Element[]{accessReqElem};
        DecisionList[] dl = XACLProcessorImpl.process(elem, targetDoc, policyElem, statusElem, roleHierarchy, groupHierarchy);
        return dl[0];
    }

    public static DecisionList[] process(Element[] accessReqElem, Document targetDoc, Element policyElem, Element statusElem, Hierarchy roleHierarchy, Hierarchy groupHierarchy) throws XaclException {
        XACLProcessorImpl xp = new XACLProcessorImpl(targetDoc, policyElem, statusElem, roleHierarchy, groupHierarchy);
        return ((XACLProcessor)xp).process(accessReqElem, null);
    }

    public static void main(String[] argv) {
        boolean validation = false;
        if (argv.length != 4) {
            System.err.println("");
            System.err.println("Usage: java -Dcom.ibm.xml.policy.xacl.gh=<group_hierarchy> -Dcom.ibm.xml.policy.xacl.rh=<role_hierarchy> com.ibm.xml.policy.xacl.XACLProcessorImpl  <access_request_file> <target_file> <policy_file> <status_file>");
            System.exit(1);
        }
        try {
            String rhfile;
            Document target = null;
            Document accessReq = null;
            Document status = null;
            Document policy = null;
            String rName = argv[0];
            String tName = argv[1];
            String pName = argv[2];
            String sName = argv[3];
            System.out.println("loading " + rName);
            DOMSource accessSource = new DOMSource(new ErrorHandlerImpl());
            try {
                accessReq = accessSource.parseByFileName(rName, true);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            System.out.println("loading " + tName);
            DOMSource targetSource = new DOMSource(new ErrorHandlerImpl());
            try {
                target = targetSource.parseByFileName(tName, false);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            System.out.println("loading " + pName);
            DOMSource policySource = new DOMSource(new ErrorHandlerImpl());
            try {
                policy = policySource.parseByFileName(pName, true);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            System.out.println("loading " + sName);
            DOMSource statusSource = new DOMSource(new ErrorHandlerImpl());
            try {
                status = statusSource.parseByFileName(sName, true);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            HierarchyImpl gh = null;
            HierarchyImpl rh = null;
            Document ghd = null;
            Document rhd = null;
            String ghfile = System.getProperty("com.ibm.xml.policy.xacl.gh");
            if (ghfile != null && !ghfile.equals("")) {
                DOMSource ghSource = new DOMSource(new ErrorHandlerImpl());
                try {
                    ghd = ghSource.parseByFileName(ghfile, false);
                    gh = new HierarchyImpl(ghd);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
            }
            if ((rhfile = System.getProperty("com.ibm.xml.policy.xacl.rh")) != null && !rhfile.equals("")) {
                DOMSource rhSource = new DOMSource(new ErrorHandlerImpl());
                try {
                    rhd = rhSource.parseByFileName(rhfile, false);
                    rh = new HierarchyImpl(rhd);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
            }
            Document decision_list = null;
            if (accessReq == null || target == null || policy == null || status == null) {
                System.err.println("Policy enforcement was not completed.");
                System.exit(1);
                return;
            }
            long start = System.currentTimeMillis();
            decision_list = XACLProcessorImpl.process(accessReq.getDocumentElement(), target, policy.getDocumentElement(), status.getDocumentElement(), (Hierarchy)rh, (Hierarchy)gh).getDocument();
            long end = System.currentTimeMillis();
            long time = end - start;
            System.out.println("The processing time was " + time + " ms.");
            System.out.println("Policy enforcement was completed.");
            if (decision_list != null) {
                FileOutputStream fos = new FileOutputStream("decision_list.xml");
                fos.write(Util.Document2ByteArray(decision_list, null, null, "UTF-8", true, true, true));
                fos.flush();
                fos.close();
            } else {
                System.out.println("Decision list is null.");
            }
            if (accessReq.getDocumentElement().getAttribute("type").equals("execute")) {
                System.out.println("See two files: target_result.xml and status_result.xml");
                FileOutputStream fos = new FileOutputStream("target_result.xml");
                fos.write(Util.Document2ByteArray(target, null, null, "UTF-8", true, true, true));
                fos.flush();
                fos.close();
                fos = new FileOutputStream("status_result.xml");
                fos.write(Util.Document2ByteArray(status, statusSource.getPublicId(), statusSource.getSystemId(), statusSource.getEncoding(), true, true, true));
                fos.flush();
                fos.close();
            }
            return;
        }
        catch (XaclException e) {
            e.printStackTrace();
            System.out.println("XaclException:");
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("XaclException:");
            System.out.println(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.out.println("ParserConfigurationException:");
            System.out.println(e.getMessage());
        }
    }
}

