/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Acl;
import com.ibm.xml.policy.xacl.Action;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.Property;
import com.ibm.xml.policy.xacl.XaclException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Subject {
    private final Acl m_Acl;
    private final String m_Uid;
    private final String[] m_Role;
    private final String[] m_Group;

    Subject(Element elem, Acl acl) throws XaclException {
        int i;
        this.m_Acl = acl;
        NodeList nl = elem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "uid");
        int size = nl.getLength();
        this.m_Uid = size > 0 ? Util.getTextNodeValue((Element)nl.item(0)) : null;
        nl = elem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "role");
        size = nl.getLength();
        if (size > 0) {
            this.m_Role = new String[size];
            for (i = 0; i < size; ++i) {
                this.m_Role[i] = Util.getTextNodeValue((Element)nl.item(i));
            }
        } else {
            this.m_Role = null;
        }
        if ((size = (nl = elem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "group")).getLength()) > 0) {
            this.m_Group = new String[size];
            for (i = 0; i < size; ++i) {
                this.m_Group[i] = Util.getTextNodeValue((Element)nl.item(i));
            }
        } else {
            this.m_Group = null;
        }
    }

    public String getUid() {
        return this.m_Uid;
    }

    public String[] getRoles() {
        return this.m_Role;
    }

    public String[] getGroups() {
        return this.m_Group;
    }

    boolean matching(AccessRequest accessReq, Hierarchy roleHierarchy, Hierarchy groupHierarchy) throws XaclException {
        int j;
        int i;
        String upp;
        String dpp;
        int check;
        Subject requestor = accessReq.getSubject();
        Property property = this.m_Acl.getRule().getXacl().getPolicy().getProperty();
        Action action = this.m_Acl.getAction(accessReq.getAction().getName());
        if (action == null) {
            return false;
        }
        String permission = action.getPermission();
        if (this.m_Uid != null) {
            if (requestor == null) {
                return false;
            }
            if (requestor.getUid() == null) {
                return false;
            }
            if (!this.m_Uid.equals(requestor.getUid())) {
                return false;
            }
        }
        if (this.m_Role != null) {
            if (requestor == null) {
                return false;
            }
            String[] q_role = requestor.getRoles();
            if (q_role == null) {
                return false;
            }
            check = 0;
            dpp = property.getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongRH("downward", permission);
            upp = property.getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongRH("upward", permission);
            block0: for (i = 0; i < q_role.length; ++i) {
                for (j = 0; j < this.m_Role.length; ++j) {
                    if (roleHierarchy == null) {
                        if (!q_role[i].equals(this.m_Role[j])) continue;
                        ++check;
                        continue block0;
                    }
                    if (q_role[i].equals(this.m_Role[j])) {
                        ++check;
                        continue block0;
                    }
                    if (dpp.equals("precedence") && roleHierarchy.isAncestorOrEqual(this.m_Role[j], q_role[i])) {
                        ++check;
                        continue block0;
                    }
                    if (!upp.equals("precedence") || !roleHierarchy.isAncestorOrEqual(q_role[i], this.m_Role[j])) continue;
                    ++check;
                    continue block0;
                }
            }
            if (check != this.m_Role.length) {
                return false;
            }
        }
        if (this.m_Group != null) {
            if (requestor == null) {
                return false;
            }
            String[] q_group = requestor.getGroups();
            if (q_group == null) {
                return false;
            }
            check = 0;
            dpp = property.getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongGH("downward", permission);
            upp = property.getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongGH("upward", permission);
            block2: for (i = 0; i < q_group.length; ++i) {
                for (j = 0; j < this.m_Group.length; ++j) {
                    if (groupHierarchy == null) {
                        if (!q_group[i].equals(this.m_Group[j])) continue;
                        ++check;
                        continue block2;
                    }
                    if (q_group[i].equals(this.m_Group[j])) {
                        ++check;
                        continue block2;
                    }
                    if (dpp.equals("precedence") && groupHierarchy.isAncestorOrEqual(this.m_Group[j], q_group[i])) {
                        ++check;
                        continue block2;
                    }
                    if (!upp.equals("precedence") || !groupHierarchy.isAncestorOrEqual(q_group[i], this.m_Group[j])) continue;
                    ++check;
                    continue block2;
                }
            }
            if (check != this.m_Group.length) {
                return false;
            }
        }
        return true;
    }

    Element createElement(Document doc) {
        Element elem = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "subject");
        if (this.m_Uid != null || this.m_Role != null || this.m_Group != null) {
            int i;
            Text text;
            if (this.m_Uid != null) {
                Element uid = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "uid");
                text = doc.createTextNode(this.m_Uid);
                uid.appendChild(text);
                if (uid != null) {
                    elem.appendChild(uid);
                }
            }
            if (this.m_Role != null) {
                for (i = 0; i < this.m_Role.length; ++i) {
                    Element role = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "role");
                    text = doc.createTextNode(this.m_Role[i]);
                    role.appendChild(text);
                    if (role == null) continue;
                    elem.appendChild(role);
                }
            }
            if (this.m_Group != null) {
                for (i = 0; i < this.m_Group.length; ++i) {
                    Element group = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "group");
                    text = doc.createTextNode(this.m_Group[i]);
                    group.appendChild(text);
                    if (group == null) continue;
                    elem.appendChild(group);
                }
            }
            return elem;
        }
        return null;
    }
}

