/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Acl;
import com.ibm.xml.policy.xacl.AclList;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.Xacl;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Rule {
    private final String m_Id;
    private final short m_Precedence;
    private final Xacl m_Xacl;
    private final Acl[] m_Acl;
    private final Hashtable m_ActionName2Acl;

    Rule(Element elem, Xacl xacl) throws XaclException {
        this.m_Xacl = xacl;
        this.m_Id = elem.getAttribute("id");
        this.m_Precedence = elem.getAttribute("precedence") == null || elem.getAttribute("precedence").equals("") ? this.m_Xacl.getPrecedenceValue() : new Short(elem.getAttribute("precedence")).shortValue();
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "acl");
        int size = vec.size();
        this.m_Acl = new Acl[size];
        this.m_ActionName2Acl = new Hashtable(size);
        for (int i = 0; i < size; ++i) {
            this.m_Acl[i] = new Acl((Element)vec.elementAt(i), this);
        }
    }

    Acl[] getAcls() {
        return this.m_Acl;
    }

    Xacl getXacl() {
        return this.m_Xacl;
    }

    short getPrecedenceValue() {
        return this.m_Precedence;
    }

    Vector findAcl(String ActionName) {
        return (Vector)this.m_ActionName2Acl.get(ActionName);
    }

    void putAcl(String ActionName, Acl acl) {
        Object obj = this.m_ActionName2Acl.get(ActionName);
        if (obj == null) {
            Vector<Acl> vec = new Vector<Acl>(this.m_Acl.length);
            vec.addElement(acl);
            this.m_ActionName2Acl.put(ActionName, vec);
        } else {
            ((Vector)obj).addElement(acl);
        }
    }

    void matching(AccessRequest accessReq, Node query, AclList aclList, DOMHandler targetDocHandler, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context, String searched_permission) throws XaclException {
        Vector vec = this.findAcl(accessReq.getAction().getName());
        if (vec != null) {
            for (int i = 0; i < vec.size(); ++i) {
                Acl acl = (Acl)vec.elementAt(i);
                acl.matching(accessReq, query, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, searched_permission);
            }
        }
    }

    void indexing(Hashtable ht, Document target, Hierarchy rh, Hierarchy gh) {
        for (int i = 0; i < this.m_Acl.length; ++i) {
            this.m_Acl[i].indexing(ht, target, rh, gh);
        }
    }
}

