/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Action;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Decision;
import com.ibm.xml.policy.xacl.Parameter;
import com.ibm.xml.policy.xacl.ProvisionalActionInterface;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProvisionalAction {
    private final String m_Name;
    private final String m_Timing;
    private final ProvisionalActionInterface m_PAI;
    private final Parameter[] m_Parameter;
    private final String m_OriginatingAclID;

    ProvisionalAction(Element elem, Action action) throws XaclException {
        Object obj;
        this.m_Name = elem.getAttribute("name");
        this.m_Timing = elem.getAttribute("timing");
        this.m_OriginatingAclID = action.getAcl().getID();
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "parameter");
        int size = vec.size();
        if (size > 0) {
            this.m_Parameter = new Parameter[size];
            for (int i = 0; i < size; ++i) {
                this.m_Parameter[i] = new Parameter((Element)vec.elementAt(i));
            }
        } else {
            this.m_Parameter = null;
        }
        try {
            obj = Class.forName(this.m_Name).newInstance();
        }
        catch (Exception e) {
            try {
                String type = "com.ibm.xml.policy.xacl.builtIn.provisional_action." + this.m_Name;
                obj = Class.forName(type).newInstance();
            }
            catch (Exception ee) {
                obj = null;
            }
        }
        this.m_PAI = obj != null ? (ProvisionalActionInterface)obj : null;
    }

    public String getOriginatingAcl() {
        return this.m_OriginatingAclID;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getTiming() {
        return this.m_Timing;
    }

    public Parameter[] getParameters() {
        return this.m_Parameter;
    }

    boolean execute(AccessRequest accessReq, Decision decision, Parameter[] paParam, DOMHandler targetDOMHandler, Element status, Object context) throws XaclException {
        if (this.m_PAI == null) {
            throw new XaclException(502, "during evaluating " + this.m_Name);
        }
        return this.m_PAI.execute(accessReq, decision, paParam, targetDOMHandler, status, context);
    }

    Element createElement(Document doc) {
        Element elem = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "provisional_action");
        elem.setAttribute("name", this.m_Name);
        elem.setAttribute("timing", this.m_Timing);
        if (this.m_Parameter != null) {
            for (int i = 0; i < this.m_Parameter.length; ++i) {
                elem.appendChild(doc.importNode(this.m_Parameter[i].getElement(), true));
            }
        }
        return elem;
    }
}

