/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.xacl.PolicyDefinition;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Property {
    private final Hashtable m_ID2PolicyDefinitionElement = new Hashtable();
    private final Hashtable m_Action2PolicyDefinition = new Hashtable();

    Property(Element elem) throws XaclException {
        this.m_Action2PolicyDefinition.put("read", new PolicyDefinition("read"));
        this.m_Action2PolicyDefinition.put("write", new PolicyDefinition("write"));
        this.m_Action2PolicyDefinition.put("create", new PolicyDefinition("create"));
        this.m_Action2PolicyDefinition.put("delete", new PolicyDefinition("delete"));
        if (elem != null) {
            this.Import(elem);
        }
    }

    private void Import(Element propertyElem) throws XaclException {
        Element elem;
        int i;
        NodeList nl = propertyElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "policy_definition");
        for (i = 0; i < nl.getLength(); ++i) {
            elem = (Element)nl.item(i);
            this.m_ID2PolicyDefinitionElement.put(elem.getAttribute("id"), elem);
        }
        nl = propertyElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "action_definition");
        for (i = 0; i < nl.getLength(); ++i) {
            elem = (Element)nl.item(i);
            String action_name = elem.getAttribute("name");
            String policy_id = elem.getAttribute("policy");
            Element pe = (Element)this.m_ID2PolicyDefinitionElement.get(policy_id);
            PolicyDefinition pd = (PolicyDefinition)this.m_Action2PolicyDefinition.get(action_name);
            if (pd == null) {
                pd = new PolicyDefinition(action_name);
            }
            pd.Override(pe);
            this.m_Action2PolicyDefinition.put(action_name, pd);
        }
    }

    PolicyDefinition getPolicyDefinition(String action) {
        return (PolicyDefinition)this.m_Action2PolicyDefinition.get(action);
    }

    void setPolicyDefinition(String action, PolicyDefinition pd) {
        this.m_Action2PolicyDefinition.put(action, pd);
    }
}

