/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.xacl.XaclException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PropagationPolicy {
    String m_DownwardGrant;
    String m_DownwardDeny;
    String m_UpwardGrant;
    String m_UpwardDeny;

    PropagationPolicy() {
    }

    PropagationPolicy(NodeList nl) throws XaclException {
        this.Import(nl);
    }

    void Import(NodeList nl) throws XaclException {
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elem = (Element)nl.item(i);
            String direction = elem.getAttribute("direction");
            String permission = elem.getAttribute("permission");
            if (direction.equals("downward") && permission.equals("grant")) {
                this.m_DownwardGrant = elem.getAttribute("name");
                continue;
            }
            if (direction.equals("downward") && permission.equals("deny")) {
                this.m_DownwardDeny = elem.getAttribute("name");
                continue;
            }
            if (direction.equals("upward") && permission.equals("grant")) {
                this.m_UpwardGrant = elem.getAttribute("name");
                continue;
            }
            if (!direction.equals("upward") || !permission.equals("deny")) continue;
            this.m_UpwardDeny = elem.getAttribute("name");
        }
    }

    String getPropagationPolicy(String direction, String permission) {
        if (direction.equals("downward") && permission.equals("grant")) {
            return this.m_DownwardGrant;
        }
        if (direction.equals("downward") && permission.equals("deny")) {
            return this.m_DownwardDeny;
        }
        if (direction.equals("upward") && permission.equals("grant")) {
            return this.m_UpwardGrant;
        }
        if (direction.equals("upward") && permission.equals("deny")) {
            return this.m_UpwardDeny;
        }
        return null;
    }
}

