/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Parameter;
import com.ibm.xml.policy.xacl.PredicateInterface;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Predicate {
    private final String m_Name;
    private final Parameter[] m_Parameter;
    private final PredicateInterface m_Predicate;

    Predicate(Element elem) throws XaclException {
        Object obj;
        this.m_Name = elem.getAttribute("name");
        try {
            obj = Class.forName(this.m_Name).newInstance();
        }
        catch (Exception e) {
            try {
                String name = "com.ibm.xml.policy.xacl.builtIn.predicate." + this.m_Name;
                obj = Class.forName(name).newInstance();
            }
            catch (Exception ee) {
                obj = null;
            }
        }
        this.m_Predicate = obj != null ? (PredicateInterface)obj : null;
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "parameter");
        int size = vec.size();
        if (size > 0) {
            this.m_Parameter = new Parameter[size];
            for (int i = 0; i < size; ++i) {
                this.m_Parameter[i] = new Parameter((Element)vec.elementAt(i));
            }
        } else {
            this.m_Parameter = null;
        }
        this.m_Predicate.initialize(this.m_Parameter);
    }

    boolean evaluate(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        if (this.m_Predicate == null) {
            throw new XaclException(404, "during evaluating " + this.m_Name);
        }
        return this.m_Predicate.evaluate(accessReq, query, this.m_Parameter, targetDocHandler, status, context);
    }
}

