/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.xacl.PropagationPolicy;
import com.ibm.xml.policy.xacl.XaclException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PolicyDefinition {
    private PropagationPolicy m_PPAlongOH = new PropagationPolicy();
    private PropagationPolicy m_PPAlongRH = new PropagationPolicy();
    private PropagationPolicy m_PPAlongGH = new PropagationPolicy();
    private String m_ConflictResolution;
    private String m_Default;

    PolicyDefinition(String action) {
        if (action.equals("read") || action.equals("write")) {
            this.m_PPAlongOH.m_DownwardGrant = "no_override";
            this.m_PPAlongOH.m_DownwardDeny = "no_override";
            this.m_PPAlongOH.m_UpwardGrant = "no";
            this.m_PPAlongOH.m_UpwardDeny = "no";
            this.m_PPAlongRH.m_DownwardGrant = "no";
            this.m_PPAlongRH.m_DownwardDeny = "no";
            this.m_PPAlongRH.m_UpwardGrant = "precedence";
            this.m_PPAlongRH.m_UpwardDeny = "no";
            this.m_PPAlongGH.m_DownwardGrant = "precedence";
            this.m_PPAlongGH.m_DownwardDeny = "no";
            this.m_PPAlongGH.m_UpwardGrant = "no";
            this.m_PPAlongGH.m_UpwardDeny = "no";
            this.m_ConflictResolution = "dtp";
            this.m_Default = "deny";
        } else if (action.equals("create")) {
            this.m_PPAlongOH.m_DownwardGrant = "no";
            this.m_PPAlongOH.m_DownwardDeny = "no";
            this.m_PPAlongOH.m_UpwardGrant = "no";
            this.m_PPAlongOH.m_UpwardDeny = "no";
            this.m_PPAlongRH.m_DownwardGrant = "no";
            this.m_PPAlongRH.m_DownwardDeny = "no";
            this.m_PPAlongRH.m_UpwardGrant = "precedence";
            this.m_PPAlongRH.m_UpwardDeny = "no";
            this.m_PPAlongGH.m_DownwardGrant = "precedence";
            this.m_PPAlongGH.m_DownwardDeny = "no";
            this.m_PPAlongGH.m_UpwardGrant = "no";
            this.m_PPAlongGH.m_UpwardDeny = "no";
            this.m_ConflictResolution = "dtp";
            this.m_Default = "deny";
        } else if (action.equals("delete")) {
            this.m_PPAlongOH.m_DownwardGrant = "no";
            this.m_PPAlongOH.m_DownwardDeny = "no";
            this.m_PPAlongOH.m_UpwardGrant = "no";
            this.m_PPAlongOH.m_UpwardDeny = "override";
            this.m_PPAlongRH.m_DownwardGrant = "no";
            this.m_PPAlongRH.m_DownwardDeny = "no";
            this.m_PPAlongRH.m_UpwardGrant = "precedence";
            this.m_PPAlongRH.m_UpwardDeny = "no";
            this.m_PPAlongGH.m_DownwardGrant = "precedence";
            this.m_PPAlongGH.m_DownwardDeny = "no";
            this.m_PPAlongGH.m_UpwardGrant = "no";
            this.m_PPAlongGH.m_UpwardDeny = "no";
            this.m_ConflictResolution = "dtp";
            this.m_Default = "deny";
        } else {
            this.m_PPAlongOH.m_DownwardGrant = "no";
            this.m_PPAlongOH.m_DownwardDeny = "no";
            this.m_PPAlongOH.m_UpwardGrant = "no";
            this.m_PPAlongOH.m_UpwardDeny = "no";
            this.m_PPAlongRH.m_DownwardGrant = "no";
            this.m_PPAlongRH.m_DownwardDeny = "no";
            this.m_PPAlongRH.m_UpwardGrant = "no";
            this.m_PPAlongRH.m_UpwardDeny = "no";
            this.m_PPAlongGH.m_DownwardGrant = "no";
            this.m_PPAlongGH.m_DownwardDeny = "no";
            this.m_PPAlongGH.m_UpwardGrant = "no";
            this.m_PPAlongGH.m_UpwardDeny = "no";
            this.m_ConflictResolution = "dtp";
            this.m_Default = "deny";
        }
    }

    void Override(Element policyDefinitionElem) throws XaclException {
        Element elem;
        NodeList nl = policyDefinitionElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "propagation_along_oh");
        if (this.m_PPAlongOH == null) {
            this.m_PPAlongOH = new PropagationPolicy(nl);
        } else {
            this.m_PPAlongOH.Import(nl);
        }
        nl = policyDefinitionElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "propagation_along_rh");
        if (this.m_PPAlongRH == null) {
            this.m_PPAlongRH = new PropagationPolicy(nl);
        } else {
            this.m_PPAlongRH.Import(nl);
        }
        nl = policyDefinitionElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "propagation_along_gh");
        if (this.m_PPAlongGH == null) {
            this.m_PPAlongGH = new PropagationPolicy(nl);
        } else {
            this.m_PPAlongGH.Import(nl);
        }
        nl = policyDefinitionElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "conflict_resolution");
        if (nl.getLength() != 0) {
            elem = (Element)nl.item(0);
            this.m_ConflictResolution = elem.getAttribute("name");
        }
        if ((nl = policyDefinitionElem.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "default")).getLength() != 0) {
            elem = (Element)nl.item(0);
            this.m_Default = elem.getAttribute("name");
        }
    }

    String getPropagationPolicyAlongOH(String direction, String permission) {
        return this.m_PPAlongOH.getPropagationPolicy(direction, permission);
    }

    String getPropagationPolicyAlongRH(String direction, String permission) {
        return this.m_PPAlongRH.getPropagationPolicy(direction, permission);
    }

    String getPropagationPolicyAlongGH(String direction, String permission) {
        return this.m_PPAlongGH.getPropagationPolicy(direction, permission);
    }

    String getConflictResolutionPolicy() {
        return this.m_ConflictResolution;
    }

    String getDefaultPolicy() {
        return this.m_Default;
    }
}

