/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Acl;
import com.ibm.xml.policy.xacl.AclList;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.Property;
import com.ibm.xml.policy.xacl.Xacl;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Policy {
    private final Property m_Property;
    private final Xacl[] m_Xacl;
    private Hashtable m_Node2Xacl;

    Policy(Element elem) throws XaclException {
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "property");
        this.m_Property = vec.size() > 0 ? new Property((Element)vec.elementAt(0)) : new Property(null);
        vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "xacl");
        int size = vec.size();
        this.m_Node2Xacl = new Hashtable(size);
        if (size > 0) {
            this.m_Xacl = new Xacl[size];
            for (int i = 0; i < size; ++i) {
                this.m_Xacl[i] = new Xacl((Element)vec.elementAt(i), this);
            }
        } else {
            this.m_Xacl = null;
        }
    }

    Xacl[] getXacl() {
        return this.m_Xacl;
    }

    Property getProperty() {
        return this.m_Property;
    }

    Vector findXacl(Node node) {
        return (Vector)this.m_Node2Xacl.get(node);
    }

    private void putXacl(Node node, Xacl xacl) {
        Object obj = this.m_Node2Xacl.get(node);
        if (obj == null) {
            Vector<Xacl> vec = new Vector<Xacl>(this.m_Xacl.length);
            vec.addElement(xacl);
            this.m_Node2Xacl.put(node, vec);
        } else {
            ((Vector)obj).addElement(xacl);
        }
    }

    void createNode2XaclTable(DOMHandler targetDocHandler) throws XaclException {
        this.m_Node2Xacl.clear();
        if (this.m_Xacl != null) {
            for (int i = 0; i < this.m_Xacl.length; ++i) {
                Node[] targetNodeArray = this.m_Xacl[i].getTargetNodes(targetDocHandler);
                for (int j = 0; j < targetNodeArray.length; ++j) {
                    this.putXacl(targetNodeArray[j], this.m_Xacl[i]);
                }
            }
        }
    }

    AclList matching(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context) throws XaclException {
        Node node;
        Xacl xacl;
        int i;
        AclList aclList = new AclList();
        Vector xaclVector = this.findXacl(query);
        if (xaclVector != null) {
            for (i = 0; i < xaclVector.size(); ++i) {
                xacl = (Xacl)xaclVector.elementAt(i);
                xacl.matching(accessReq, query, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, null);
            }
        }
        String down_grant_prop = this.getProperty().getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongOH("downward", "grant");
        String down_deny_prop = this.getProperty().getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongOH("downward", "deny");
        boolean flag_grant = down_grant_prop.equals("precedence");
        boolean flag_deny = down_deny_prop.equals("precedence");
        if (flag_grant || flag_deny) {
            Enumeration e = this.m_Node2Xacl.keys();
            while (e.hasMoreElements()) {
                node = (Node)e.nextElement();
                if (!targetDocHandler.isAncestor(node, query) || (xaclVector = this.findXacl(node)) == null) continue;
                for (i = 0; i < xaclVector.size(); ++i) {
                    xacl = (Xacl)xaclVector.elementAt(i);
                    if (flag_grant && flag_deny) {
                        xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, null);
                        continue;
                    }
                    if (flag_grant) {
                        xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, "grant");
                        continue;
                    }
                    if (!flag_deny) continue;
                    xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, "deny");
                }
            }
        }
        String up_grant_prop = this.getProperty().getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongOH("upward", "grant");
        String up_deny_prop = this.getProperty().getPolicyDefinition(accessReq.getAction().getName()).getPropagationPolicyAlongOH("upward", "deny");
        flag_grant = up_grant_prop.equals("precedence");
        flag_deny = up_deny_prop.equals("precedence");
        if (flag_grant || flag_deny) {
            Enumeration e = this.m_Node2Xacl.keys();
            while (e.hasMoreElements()) {
                node = (Node)e.nextElement();
                if (!targetDocHandler.isAncestor(query, node) || (xaclVector = this.findXacl(node)) == null) continue;
                for (i = 0; i < xaclVector.size(); ++i) {
                    xacl = (Xacl)xaclVector.elementAt(i);
                    if (flag_grant && flag_deny) {
                        xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, null);
                        continue;
                    }
                    if (flag_grant) {
                        xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, "grant");
                        continue;
                    }
                    if (!flag_deny) continue;
                    xacl.matching(accessReq, node, aclList, targetDocHandler, status, roleHierarchy, groupHierarchy, context, "deny");
                }
            }
        }
        return aclList;
    }

    Hashtable indexing(Document target, Hierarchy rh, Hierarchy gh) {
        Hashtable ht = new Hashtable();
        if (this.m_Xacl != null) {
            for (int i = 0; i < this.m_Xacl.length; ++i) {
                this.m_Xacl[i].indexing(ht, target, rh, gh);
            }
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Vector vec = (Vector)ht.get(e.nextElement());
            Acl[] acls = new Acl[vec.size()];
            System.arraycopy(vec.toArray(), 0, acls, 0, acls.length);
            Arrays.sort(acls, Acl.getPrecedenceComparator());
            for (int i = 0; i < acls.length; ++i) {
                vec.setElementAt(acls[i], i);
            }
        }
        return ht;
    }
}

