/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Function;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parameter {
    private final Element m_ThisElement;
    private final String m_Name;
    private final String m_Value;
    private final Function m_Function;

    Parameter(Element elem) throws XaclException {
        this.m_ThisElement = elem;
        this.m_Name = elem.hasAttribute("name") ? elem.getAttribute("name") : null;
        this.m_Value = elem.hasAttribute("value") ? elem.getAttribute("value") : null;
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "function");
        if (vec.size() > 0) {
            this.m_Function = new Function((Element)vec.elementAt(0));
            return;
        }
        this.m_Function = null;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getValue() {
        return this.m_Value;
    }

    public Element getElement() {
        return this.m_ThisElement;
    }

    public Node[] evaluate(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        if (this.m_Value != null) {
            Node[] node = new Node[]{this.m_ThisElement.getOwnerDocument().createTextNode(this.m_Value)};
            return node;
        }
        if (this.m_Function != null) {
            return this.m_Function.evaluate(accessReq, query, targetDocHandler, status, context);
        }
        NodeList nl = this.m_ThisElement.getChildNodes();
        int size = nl.getLength();
        Node[] node = new Node[size];
        for (int i = 0; i < size; ++i) {
            node[i] = nl.item(i);
        }
        if (node.length > 0) {
            return node;
        }
        node = new Node[]{this.m_ThisElement.getOwnerDocument().createTextNode("")};
        return node;
    }
}

