/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.FunctionInterface;
import com.ibm.xml.policy.xacl.Parameter;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Function {
    private final String m_Name;
    private final Parameter[] m_Parameter;
    private final FunctionInterface m_Function;

    Function(Element elem) throws XaclException {
        Object obj;
        this.m_Name = elem.getAttribute("name");
        try {
            obj = Class.forName(this.m_Name).newInstance();
        }
        catch (Exception e) {
            try {
                String name = "com.ibm.xml.policy.xacl.builtIn.function." + this.m_Name;
                obj = Class.forName(name).newInstance();
            }
            catch (Exception ee) {
                obj = null;
            }
        }
        this.m_Function = obj != null ? (FunctionInterface)obj : null;
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "parameter");
        int size = vec.size();
        if (size > 0) {
            this.m_Parameter = new Parameter[size];
            for (int i = 0; i < size; ++i) {
                this.m_Parameter[i] = new Parameter((Element)vec.elementAt(i));
            }
        } else {
            this.m_Parameter = null;
        }
        this.m_Function.initialize(this.m_Parameter);
    }

    Node[] evaluate(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        if (this.m_Function == null) {
            throw new XaclException(403, "Function " + this.m_Name);
        }
        return this.m_Function.evaluate(accessReq, query, this.m_Parameter, targetDocHandler, status, context);
    }
}

