/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Decision;
import com.ibm.xml.policy.xacl.DecisionList;
import com.ibm.xml.policy.xacl.Parameter;
import com.ibm.xml.policy.xacl.ProvisionalAction;
import com.ibm.xml.policy.xacl.XaclException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Executor {
    Executor() {
    }

    void execute(DecisionList decisionList, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        if (decisionList == null || targetDocHandler == null) {
            return;
        }
        if (decisionList.getAccessRequest().getType().equals("execute")) {
            this.executeDecisions(decisionList, targetDocHandler, status, context);
        }
    }

    private void executeDecisions(DecisionList decisionList, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        Parameter[] pactionParam;
        ProvisionalAction pa;
        int j;
        int pactionSize;
        Decision decision;
        int i;
        int decisionListSize = decisionList.size();
        int check = 0;
        String actionName = decisionList.getAccessRequest().getAction().getName();
        if (!actionName.equals("read")) {
            for (i = 0; i < decisionListSize; ++i) {
                decision = decisionList.elementAt(i);
                pactionSize = decision.getProvisionalActions() != null ? decision.getProvisionalActions().length : 0;
                for (j = 0; j < pactionSize; ++j) {
                    boolean result;
                    pa = decision.getProvisionalActions()[j];
                    pactionParam = decision.getProvisionalActions()[j].getParameters();
                    if (!pa.getTiming().equals("before") || (result = pa.execute(decisionList.getAccessRequest(), decision, pactionParam, targetDocHandler, status, context))) continue;
                    ++check;
                }
            }
        }
        if (check > 0) {
            return;
        }
        if (actionName.equals("read")) {
            this.createView(decisionList, targetDocHandler);
        } else {
            decision = decisionList.getDecision(0);
            Parameter[] actionParam = decisionList.getAccessRequest().getAction().getParameters();
            String actionPermission = decision.getPermission();
            if (actionName.equals("write") && actionPermission.equals("grant")) {
                if (actionParam == null) {
                    throw new XaclException(703, "while executing decisions");
                }
                if (actionParam.length < 1) {
                    throw new XaclException(703, "while executing decisions");
                }
                targetDocHandler.write(decision.getTargetNode(), actionParam[0].getValue());
            } else if (actionName.equals("delete") && actionPermission.equals("grant")) {
                targetDocHandler.delete(decision.getTargetNode());
            } else if (actionName.equals("create") && actionPermission.equals("grant")) {
                if (actionParam == null) {
                    throw new XaclException(702, "while executing decisions");
                }
                if (actionParam.length < 1) {
                    throw new XaclException(702, "while executing decisions");
                }
                Element paramE = actionParam[0].getElement();
                NodeList nl = paramE.getChildNodes();
                Node[] param = new Node[nl.getLength()];
                for (j = 0; j < nl.getLength(); ++j) {
                    param[j] = nl.item(j);
                }
                targetDocHandler.create(decision.getTargetNode(), param);
            }
        }
        for (i = 0; i < decisionListSize; ++i) {
            decision = decisionList.elementAt(i);
            pactionSize = decision.getProvisionalActions() != null ? decision.getProvisionalActions().length : 0;
            for (j = 0; j < pactionSize; ++j) {
                pa = decision.getProvisionalActions()[j];
                pactionParam = decision.getProvisionalActions()[j].getParameters();
                if (!pa.getTiming().equals("after")) continue;
                pa.execute(decisionList.getAccessRequest(), decision, pactionParam, targetDocHandler, status, context);
            }
        }
    }

    private void createView(DecisionList decisionList, DOMHandler targetDocHandler) throws XaclException {
        Element root = targetDocHandler.getDocument().getDocumentElement();
        this.removeNotAllowedToReadNodes(root, decisionList, targetDocHandler);
        this.removeElements(decisionList, root);
    }

    private void removeNotAllowedToReadNodes(Element elem, DecisionList decisionList, DOMHandler targetDocHandler) throws XaclException {
        boolean permission_e = false;
        try {
            permission_e = decisionList.getPermission(elem);
        }
        catch (XaclException ex) {
            if (ex.getCode() != 104) {
                throw ex;
            }
            permission_e = false;
        }
        NodeList nl = elem.getChildNodes();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = nl.item(i);
            if (nl.item(i).getNodeType() == 1) {
                this.removeNotAllowedToReadNodes((Element)nl.item(i), decisionList, targetDocHandler);
                continue;
            }
            if (permission_e) continue;
            elem.removeChild(nl.item(i));
            --i;
            --size;
        }
        NamedNodeMap map = elem.getAttributes();
        size = map.getLength();
        boolean permission_a = false;
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)map.item(i);
            try {
                permission_a = decisionList.getPermission(attr);
            }
            catch (XaclException ex) {
                if (ex.getCode() != 104) {
                    throw ex;
                }
                permission_a = false;
            }
            if (permission_a || attr.getName().startsWith("xmlns:") || attr.getName().equals("xmlns")) continue;
            Attr attr2 = Util.removeAttributeNode(elem, attr);
            if (attr2 == null) {
                throw new XaclException(705, "when creating the view");
            }
            --i;
            --size;
        }
    }

    private boolean removeElements(DecisionList decisionList, Element elem) throws XaclException {
        boolean permission;
        try {
            permission = decisionList.getPermission(elem);
        }
        catch (XaclException ex) {
            if (ex.getCode() != 104) {
                throw ex;
            }
            permission = false;
        }
        int NumOfChildElements = 0;
        NodeList nl = elem.getChildNodes();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            ++NumOfChildElements;
        }
        NamedNodeMap map = elem.getAttributes();
        int NumOfAttributes = map.getLength();
        if (NumOfChildElements == 0 && NumOfAttributes == 0) {
            if (permission) {
                return false;
            }
            if (elem.getParentNode().getNodeType() != 9) {
                elem.getParentNode().removeChild(elem);
                return true;
            }
            return false;
        }
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            boolean b = this.removeElements(decisionList, (Element)nl.item(i));
            if (b) {
                --i;
                --size;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            for (int i = 0; i < NumOfAttributes; ++i) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().equals("xmlns") || attr.getName().startsWith("xmlns:")) continue;
                ++count;
                break;
            }
        }
        if (count == 0) {
            if (elem.getParentNode().getNodeType() != 9) {
                elem.getParentNode().removeChild(elem);
                return true;
            }
            return false;
        }
        return false;
    }
}

