/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Acl;
import com.ibm.xml.policy.xacl.AclList;
import com.ibm.xml.policy.xacl.Action;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Decision;
import com.ibm.xml.policy.xacl.DecisionList;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.Policy;
import com.ibm.xml.policy.xacl.PolicyDefinition;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Evaluator {
    private final Hashtable m_Pool = new Hashtable();
    private final Hashtable m_Node2XPathTable = new Hashtable();

    Evaluator() {
    }

    DecisionList evaluate(AccessRequest accessReq, DOMHandler targetDocHandler, Policy policy, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context) throws XaclException {
        DecisionList decisionList = new DecisionList(accessReq);
        String requested_action = accessReq.getAction().getName();
        if (policy.getProperty().getPolicyDefinition(requested_action) == null) {
            policy.getProperty().setPolicyDefinition(requested_action, new PolicyDefinition(requested_action));
        }
        this.m_Pool.clear();
        this.m_Node2XPathTable.clear();
        this.internal_evaluate(accessReq, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context, decisionList);
        if (!accessReq.getType().equals("basic") && (requested_action.equals("read") || accessReq.getType().equals("query"))) {
            Node tn = accessReq.getTargetNode();
            Hashtable Node2XPath = this.createNode2XPathTable(tn);
            for (int i = 0; i < decisionList.size(); ++i) {
                Decision d = decisionList.elementAt(i);
                String xpath = (String)Node2XPath.get(d.getTargetNode());
                if (xpath == null) {
                    throw new XaclException(605, "when making a Node2XPath table");
                }
                d.setTargetNodeXPath(xpath);
            }
        } else {
            Decision d = decisionList.elementAt(0);
            d.setTargetNodeXPath(accessReq.getTargetNodeXPath());
        }
        return decisionList;
    }

    private void internal_evaluate(AccessRequest accessReq, DOMHandler targetDocHandler, Policy policy, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context, DecisionList decisionList) throws XaclException {
        Node query = accessReq.getTargetNode();
        Decision decision = this.basic_evaluation(accessReq, query, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
        decisionList.addElement(decision);
        boolean eval_subtree = false;
        eval_subtree = accessReq.getType().equals("basic") ? false : (accessReq.getType().equals("query") ? true : (accessReq.getType().equals("execute") ? !(accessReq.getAction().getName().equals("write") || accessReq.getAction().getName().equals("create") || accessReq.getAction().getName().equals("delete")) : false));
        if (accessReq.getTargetNode().getNodeType() == 2) {
            eval_subtree = false;
        }
        if (eval_subtree) {
            this.basic_evaluation_for_subtree(accessReq, (Element)query, decisionList, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
        }
    }

    private void basic_evaluation_for_subtree(AccessRequest accessReq, Element query, DecisionList decisionList, DOMHandler targetDocHandler, Policy policy, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context) throws XaclException {
        Decision decision;
        if (!accessReq.getAction().getName().equals("create")) {
            NamedNodeMap map = query.getAttributes();
            int attr_size = map.getLength();
            for (int i = 0; i < attr_size; ++i) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().startsWith("xmlns:") || attr.getName().equals("xmlns")) continue;
                decision = this.basic_evaluation(accessReq, attr, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
                decisionList.addElement(decision);
            }
        }
        NodeList nodeList = query.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            decision = this.basic_evaluation(accessReq, (Element)nodeList.item(i), targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
            decisionList.addElement(decision);
            this.basic_evaluation_for_subtree(accessReq, (Element)nodeList.item(i), decisionList, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
        }
    }

    private Decision basic_evaluation(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Policy policy, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context) throws XaclException {
        Node parent;
        Decision decision;
        String requestedAction = accessReq.getAction().getName();
        Decision poolDecision = (Decision)this.m_Pool.get(query);
        if (poolDecision != null) {
            return poolDecision;
        }
        AclList aclList = policy.matching(accessReq, query, targetDocHandler, status, roleHierarchy, groupHierarchy, context);
        DecisionList decision_list = new DecisionList(accessReq);
        for (int i = 0; i < aclList.size(); ++i) {
            Acl acl = aclList.elementAt(i);
            Action action = acl.getAction(accessReq.getAction().getName());
            decision = new Decision();
            decision.setTargetNode(query);
            decision.setPrecedenceValue(acl.getPrecedenceValue());
            decision.setPermission(action.getPermission());
            decision.setProvisionalActions(action.getProvisionalActions());
            if (acl.getID() != null && !acl.getID().equals("")) {
                decision.setOriginatingAcl(acl.getID());
            }
            decision_list.addElement(decision);
        }
        String ugp = policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", "grant");
        String udp = policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", "deny");
        String dgp = policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("downward", "grant");
        String ddp = policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("downward", "deny");
        if ((dgp.equals("override") || dgp.equals("no_override") || ddp.equals("override") || ddp.equals("no_override")) && (parent = query.getNodeType() == 2 ? ((Attr)query).getOwnerElement() : query.getParentNode()).getNodeType() != 9) {
            decision = this.basic_evaluation(accessReq, parent, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
            String pn = null;
            if (decision.getPermission().equals("grant")) {
                pn = dgp;
            } else if (decision.getPermission().equals("deny")) {
                pn = ddp;
            }
            if (pn.equals("override")) {
                decision_list.removeAllElements();
                decision = decision.cloneDecision();
                decision.setTargetNode(query);
                decision_list.addElement(decision);
            } else if (pn.equals("no_override")) {
                if (decision_list.size() == 0) {
                    decision = decision.cloneDecision();
                    decision.setTargetNode(query);
                    decision_list.addElement(decision);
                }
            } else if (pn.equals("precedence")) {
                // empty if block
            }
        }
        if (ugp.equals("override") || ugp.equals("no_override") || udp.equals("override") || udp.equals("no_override")) {
            int i;
            int i2;
            DecisionList temp_decision_list = new DecisionList(accessReq);
            NodeList nodeList = query.getChildNodes();
            int child_size = nodeList.getLength();
            NamedNodeMap map = null;
            int attr_size = 0;
            if (query.getNodeType() == 1) {
                map = query.getAttributes();
                attr_size = map.getLength();
            }
            for (i2 = 0; i2 < child_size; ++i2) {
                if (nodeList.item(i2).getNodeType() != 1) continue;
                decision = this.basic_evaluation(accessReq, nodeList.item(i2), targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
                decision = decision.cloneDecision();
                decision.setTargetNode(query);
                temp_decision_list.addElement(decision);
            }
            if (query.getNodeType() == 1) {
                for (i2 = 0; i2 < attr_size; ++i2) {
                    Attr attr = (Attr)map.item(i2);
                    if (attr.getName().startsWith("xmlns:") || attr.getName().equals("xmlns")) continue;
                    decision = this.basic_evaluation(accessReq, attr, targetDocHandler, policy, status, roleHierarchy, groupHierarchy, context);
                    decision = decision.cloneDecision();
                    decision.setTargetNode(query);
                    temp_decision_list.addElement(decision);
                }
            }
            for (i2 = 0; i2 < temp_decision_list.size(); ++i2) {
                decision = temp_decision_list.elementAt(i2);
                if (!policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", decision.getPermission()).equals("no")) continue;
                temp_decision_list.removeElement(decision);
                --i2;
            }
            boolean or = false;
            boolean nor = false;
            if (decision_list.size() != 0) {
                for (i = 0; i < temp_decision_list.size(); ++i) {
                    decision = temp_decision_list.elementAt(i);
                    if (!policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", decision.getPermission()).equals("no_override")) continue;
                    temp_decision_list.removeElement(decision);
                    --i;
                }
                if (temp_decision_list.size() != 0) {
                    or = true;
                }
            } else {
                for (i = 0; i < temp_decision_list.size(); ++i) {
                    decision = temp_decision_list.elementAt(i);
                    if (policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", decision.getPermission()).equals("override")) {
                        or = true;
                    }
                    if (!policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", decision.getPermission()).equals("no_override")) continue;
                    nor = true;
                }
                if (or && nor) {
                    for (i = 0; i < temp_decision_list.size(); ++i) {
                        decision = temp_decision_list.elementAt(i);
                        if (!policy.getProperty().getPolicyDefinition(requestedAction).getPropagationPolicyAlongOH("upward", decision.getPermission()).equals("no_override")) continue;
                        temp_decision_list.removeElement(decision);
                        --i;
                    }
                    nor = false;
                }
            }
            if (temp_decision_list.size() != 0) {
                if (or) {
                    decision_list.removeAllElements();
                    for (i = 0; i < temp_decision_list.size(); ++i) {
                        decision = temp_decision_list.elementAt(i);
                        decision = decision.cloneDecision();
                        decision.setTargetNode(query);
                        decision_list.addElement(decision);
                    }
                } else if (decision_list.size() == 0) {
                    for (i = 0; i < temp_decision_list.size(); ++i) {
                        decision = temp_decision_list.elementAt(i);
                        decision = decision.cloneDecision();
                        decision.setTargetNode(query);
                        decision_list.addElement(decision);
                    }
                }
            }
        }
        if (decision_list.size() > 0) {
            decision_list.resolve_conflict(policy);
        }
        if (decision_list.size() == 0) {
            String dp = policy.getProperty().getPolicyDefinition(accessReq.getAction().getName()).getDefaultPolicy();
            if (dp.equals("error")) {
                throw new XaclException(608, null);
            }
            if (dp.equals("none")) {
                throw new XaclException(609, null);
            }
            decision = new Decision();
            decision.setIsDefaultPolicyApplied(true);
            decision.setTargetNode(query);
            decision.setPermission(dp);
            this.m_Pool.put(query, decision);
            return decision;
        }
        decision = decision_list.elementAt(0);
        decision = decision.cloneDecision();
        this.m_Pool.put(query, decision);
        return decision;
    }

    private Hashtable createNode2XPathTable(Node root) {
        this.m_Node2XPathTable.clear();
        String xpath = Util.makeXPath(root);
        this.m_Node2XPathTable.put(root, xpath);
        if (root.getNodeType() == 1) {
            Evaluator.createXPathTableForSubTree((Element)root, xpath, this.m_Node2XPathTable);
        }
        return this.m_Node2XPathTable;
    }

    private static void createXPathTableForSubTree(Element elem, String xpath, Hashtable ht) {
        NamedNodeMap map = elem.getAttributes();
        int attr_size = map.getLength();
        for (int i = 0; i < attr_size; ++i) {
            Attr attr = (Attr)map.item(i);
            if (attr.getName().startsWith("xmlns:") || attr.getName().equals("xmlns")) continue;
            String attr_xpath = xpath + "/@" + attr.getName();
            ht.put(attr, attr_xpath);
        }
        NodeList nl1 = elem.getChildNodes();
        int nl1_size = nl1.getLength();
        for (int i = 0; i < nl1_size; ++i) {
            if (nl1.item(i).getNodeType() != 1) continue;
            String tag = Util.removePrefix(((Element)nl1.item(i)).getTagName());
            String nsURI = nl1.item(i).getNamespaceURI();
            if (ht.get(nl1.item(i)) != null) continue;
            NodeList nl2 = nsURI == null || nsURI.equals("") ? elem.getElementsByTagName(tag) : elem.getElementsByTagNameNS(nsURI, tag);
            int nl2_size = nl2.getLength();
            for (int j = 0; j < nl2_size; ++j) {
                if (nl2.item(j).getParentNode() != elem) continue;
                String child_xpath = nsURI == null || nsURI.equals("") ? xpath + "/" + tag : xpath + "/*[local-name()=\"" + tag + "\"][namespace-uri()=\"" + nsURI + "\"]";
                if (nl2_size > 1) {
                    int index = j + 1;
                    child_xpath = child_xpath + "[" + index + "]";
                }
                ht.put(nl2.item(j), child_xpath);
                Evaluator.createXPathTableForSubTree((Element)nl2.item(j), child_xpath, ht);
            }
        }
    }
}

