/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.Decision;
import com.ibm.xml.policy.xacl.Policy;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecisionList {
    private final Hashtable m_Node2Decision;
    private final Vector m_DecisionList = new Vector();
    private final AccessRequest m_AccessRequest;
    private int m_NumOfGrant;
    private int m_NumOfDeny;

    DecisionList(AccessRequest accessReq) {
        this.m_Node2Decision = new Hashtable();
        this.m_AccessRequest = accessReq;
        this.m_NumOfGrant = 0;
        this.m_NumOfDeny = 0;
    }

    void addElement(Decision decision) {
        this.m_DecisionList.addElement(decision);
        this.m_Node2Decision.put(decision.getTargetNode(), decision);
        if (decision.getPermission().equals("grant")) {
            ++this.m_NumOfGrant;
        } else if (decision.getPermission().equals("deny")) {
            ++this.m_NumOfDeny;
        }
    }

    void removeElement(Decision decision) {
        if (this.m_DecisionList.removeElement(decision)) {
            if (decision.getPermission().equals("grant")) {
                --this.m_NumOfGrant;
            } else if (decision.getPermission().equals("deny")) {
                --this.m_NumOfDeny;
            }
        }
    }

    public int size() {
        return this.m_DecisionList.size();
    }

    public Decision getDecision(int i) {
        return this.elementAt(i);
    }

    Decision elementAt(int i) {
        return (Decision)this.m_DecisionList.elementAt(i);
    }

    public Decision getDecision(Node node) throws XaclException {
        Decision d = (Decision)this.m_Node2Decision.get(node);
        if (d == null) {
            throw new XaclException(104, "(" + Util.makeXPath(node) + ")");
        }
        return d;
    }

    void removeAllElements() {
        this.m_DecisionList.removeAllElements();
        this.m_NumOfGrant = 0;
        this.m_NumOfDeny = 0;
    }

    public AccessRequest getAccessRequest() {
        return this.m_AccessRequest;
    }

    public boolean getPermission(Node node) throws XaclException {
        Decision d = (Decision)this.m_Node2Decision.get(node);
        if (d == null || d.getPermission() == null) {
            throw new XaclException(104, "during checking the decision list on " + Util.makeXPath(node));
        }
        return d.getPermission().equals("grant");
    }

    public Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "decision_list");
        root.setAttribute("xmlns", "http://www.trl.ibm.com/projects/xml/xacl");
        document.appendChild(root);
        root.appendChild(this.m_AccessRequest.createElement(document));
        for (int i = 0; i < this.m_DecisionList.size(); ++i) {
            Decision d = (Decision)this.m_DecisionList.elementAt(i);
            root.appendChild(d.createElement(document));
        }
        return document;
    }

    void resolve_conflict(Policy policy) throws XaclException {
        String action_name = this.m_AccessRequest.getAction().getName();
        if (this.m_NumOfGrant > 0 && this.m_NumOfDeny > 0) {
            String crp = policy.getProperty().getPolicyDefinition(action_name).getConflictResolutionPolicy();
            int size = this.m_DecisionList.size();
            if (crp.equals("dtp")) {
                for (int i = 0; i < size; ++i) {
                    if (!this.elementAt(i).getPermission().equals("grant")) continue;
                    this.removeElement(this.elementAt(i));
                    --i;
                    --size;
                }
            } else if (crp.equals("gtp")) {
                for (int i = 0; i < size; ++i) {
                    if (!this.elementAt(i).getPermission().equals("deny")) continue;
                    this.removeElement(this.elementAt(i));
                    --i;
                    --size;
                }
            } else {
                if (crp.equals("ntp")) {
                    this.removeAllElements();
                    return;
                }
                if (crp.equals("error")) {
                    throw new XaclException(607, null);
                }
            }
        } else {
            return;
        }
    }
}

