/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.XaclException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMHandler {
    private final Document m_Document;

    DOMHandler(Document doc) {
        this.m_Document = doc;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void write(Node node, String parameter) {
        if (parameter == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                NodeList nodeList = node.getChildNodes();
                int size = nodeList.getLength();
                for (int i = 0; i < size; ++i) {
                    if (nodeList.item(i).getNodeType() != 3) continue;
                    node.removeChild(nodeList.item(i));
                }
                if (parameter != null) {
                    Text text = this.m_Document.createTextNode(parameter);
                    node.appendChild(text);
                }
                return;
            }
            case 2: {
                Attr attr = (Attr)node;
                attr.setNodeValue(parameter);
                return;
            }
        }
    }

    public void delete(Node node) throws XaclException {
        switch (node.getNodeType()) {
            case 1: {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(node);
                }
                return;
            }
            case 2: {
                Attr attr = (Attr)node;
                Element owner = attr.getOwnerElement();
                Attr result = Util.removeAttributeNode(owner, attr);
                if (result == null) {
                    throw new XaclException(705, "when performing the \"delete\" action");
                }
                return;
            }
        }
    }

    public void create(Node node, Node[] parameter) {
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < parameter.length; ++i) {
            Node p = this.m_Document.importNode(parameter[i], true);
            node.appendChild(p);
        }
    }

    boolean isAncestor(Node ancestor, Node node) {
        if (ancestor.getOwnerDocument() != this.m_Document) {
            return false;
        }
        if (node.getOwnerDocument() != this.m_Document) {
            return false;
        }
        while ((node = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode()).getNodeType() != 9) {
            if (ancestor != node) continue;
            return true;
        }
        return false;
    }
}

